/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.SimpleResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.List;

public class CompatibleRepositoryVersionDefinition
extends SimpleResourceDefinition {
    public CompatibleRepositoryVersionDefinition() {
        super(Resource.Type.CompatibleRepositoryVersion, "compatible_repository_version", "compatible_repository_versions", Resource.Type.OperatingSystem);
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        List<ResourceDefinition.PostProcessor> listProcessors = super.getPostProcessors();
        listProcessors.add(new CompatibleRepositoryVersionHrefProcessor());
        return listProcessors;
    }

    private class CompatibleRepositoryVersionHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private CompatibleRepositoryVersionHrefProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            if (resultNode.getObject().getType() == Resource.Type.CompatibleRepositoryVersion) {
                Resource node = resultNode.getObject();
                Object id = node.getPropertyValue("CompatibleRepositoryVersions/id");
                Object stackVersion = node.getPropertyValue("CompatibleRepositoryVersions/stack_version");
                if (id != null && stackVersion != null) {
                    resultNode.setProperty("href", this.fixHref(href, id, stackVersion));
                    return;
                }
            }
            super.process(request, resultNode, href);
        }

        private String fixHref(String href, Object id, Object stackVersion) {
            if (!((String)(href = ((String)href).replaceAll("/versions/[^/]+/", "/versions/" + stackVersion + "/"))).endsWith("/" + id)) {
                href = (String)href + "/" + id;
            }
            return href;
        }
    }
}

