/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.query.render.ClusterBlueprintRenderer;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.controller.internal.BlueprintExportType;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ClusterResourceDefinition
extends BaseResourceDefinition {
    public ClusterResourceDefinition() {
        super(Resource.Type.Cluster);
    }

    @Override
    public String getPluralName() {
        return "clusters";
    }

    @Override
    public String getSingularName() {
        return "cluster";
    }

    @Override
    public Renderer getRenderer(String name) {
        Optional<BlueprintExportType> blueprintExportType = BlueprintExportType.parse(name);
        return blueprintExportType.isPresent() ? new ClusterBlueprintRenderer(blueprintExportType.get()) : super.getRenderer(name);
    }

    @Override
    public Set<SubResourceDefinition> getSubResourceDefinitions() {
        HashSet<SubResourceDefinition> setChildren = new HashSet<SubResourceDefinition>();
        setChildren.add(new SubResourceDefinition(Resource.Type.Service));
        setChildren.add(new SubResourceDefinition(Resource.Type.Host));
        setChildren.add(new SubResourceDefinition(Resource.Type.Configuration));
        setChildren.add(new SubResourceDefinition(Resource.Type.ServiceConfigVersion));
        setChildren.add(new SubResourceDefinition(Resource.Type.Request));
        setChildren.add(new SubResourceDefinition(Resource.Type.Workflow));
        setChildren.add(new SubResourceDefinition(Resource.Type.ConfigGroup));
        setChildren.add(new SubResourceDefinition(Resource.Type.ClusterPrivilege));
        setChildren.add(new SubResourceDefinition(Resource.Type.AlertDefinition));
        setChildren.add(new SubResourceDefinition(Resource.Type.Alert));
        setChildren.add(new SubResourceDefinition(Resource.Type.ClusterStackVersion));
        setChildren.add(new SubResourceDefinition(Resource.Type.ClusterKerberosDescriptor));
        setChildren.add(new SubResourceDefinition(Resource.Type.Artifact));
        return setChildren;
    }

    @Override
    public Collection<String> getUpdateDirectives() {
        Collection<String> directives = super.getUpdateDirectives();
        directives.add("regenerate_keytabs");
        directives.add("manage_kerberos_identities");
        directives.add("force_toggle_kerberos");
        directives.add("regenerate_hosts");
        directives.add("regenerate_components");
        directives.add("ignore_config_updates");
        directives.add("config_update_policy");
        return directives;
    }
}

