/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.query.render.DefaultRenderer;
import id.onyx.obdp.server.api.query.render.MetricsPaddingRenderer;
import id.onyx.obdp.server.api.query.render.MinimalRenderer;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;

public abstract class BaseResourceDefinition
implements ResourceDefinition {
    private Resource.Type m_type;
    private final Set<SubResourceDefinition> subResourceDefinitions = new HashSet<SubResourceDefinition>();
    private final Map<DirectiveType, Collection<String>> directives = new HashMap<DirectiveType, Collection<String>>();

    public BaseResourceDefinition(Resource.Type resourceType) {
        this(resourceType, (Collection<Resource.Type>)null, (Map<DirectiveType, ? extends Collection<String>>)null);
    }

    public BaseResourceDefinition(Resource.Type resourceType, Resource.Type ... subTypes) {
        this(resourceType, subTypes == null ? null : Arrays.asList(subTypes), null);
    }

    public BaseResourceDefinition(Resource.Type resourceType, Collection<Resource.Type> subTypes, Map<DirectiveType, ? extends Collection<String>> directives) {
        this.m_type = resourceType;
        if (subTypes != null) {
            for (Resource.Type subType : subTypes) {
                this.subResourceDefinitions.add(new SubResourceDefinition(subType));
            }
        }
        this.initializeDirectives(DirectiveType.READ, directives);
        this.initializeDirectives(DirectiveType.CREATE, directives);
        this.initializeDirectives(DirectiveType.UPDATE, directives);
        this.initializeDirectives(DirectiveType.DELETE, directives);
    }

    @Override
    public Resource.Type getType() {
        return this.m_type;
    }

    @Override
    public Set<SubResourceDefinition> getSubResourceDefinitions() {
        return this.subResourceDefinitions;
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        ArrayList<ResourceDefinition.PostProcessor> listProcessors = new ArrayList<ResourceDefinition.PostProcessor>();
        listProcessors.add(new BaseHrefPostProcessor());
        return listProcessors;
    }

    @Override
    public Renderer getRenderer(String name) {
        if (name == null || name.equals("default")) {
            return new DefaultRenderer();
        }
        if (name.equals("minimal")) {
            return new MinimalRenderer();
        }
        if (name.contains("null_padding") || name.contains("no_padding") || name.contains("zero_padding")) {
            return new MetricsPaddingRenderer(name);
        }
        throw new IllegalArgumentException("Invalid renderer name for resource of type " + this.m_type);
    }

    ClusterController getClusterController() {
        return ClusterControllerHelper.getClusterController();
    }

    @Override
    public Collection<String> getReadDirectives() {
        return this.directives.get((Object)DirectiveType.READ);
    }

    @Override
    public Collection<String> getCreateDirectives() {
        return this.directives.get((Object)DirectiveType.CREATE);
    }

    @Override
    public Collection<String> getUpdateDirectives() {
        return this.directives.get((Object)DirectiveType.UPDATE);
    }

    @Override
    public Collection<String> getDeleteDirectives() {
        return this.directives.get((Object)DirectiveType.DELETE);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (this == o) {
            result = true;
        }
        if (o instanceof BaseResourceDefinition) {
            BaseResourceDefinition other = (BaseResourceDefinition)o;
            if (this.m_type == other.m_type) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.m_type.hashCode();
    }

    @Override
    public boolean isCreatable() {
        return true;
    }

    private void initializeDirectives(DirectiveType type, Map<DirectiveType, ? extends Collection<String>> directives) {
        HashSet<String> requestDirectives = new HashSet<String>();
        if (directives != null && directives.get((Object)type) != null) {
            requestDirectives.addAll(directives.get((Object)type));
        }
        this.directives.put(type, requestDirectives);
    }

    public static enum DirectiveType {
        CREATE,
        READ,
        UPDATE,
        DELETE;

    }

    class BaseHrefPostProcessor
    implements ResourceDefinition.PostProcessor {
        BaseHrefPostProcessor() {
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            Resource r = resultNode.getObject();
            TreeNode<Resource> parent = resultNode.getParent();
            if (parent.getName() != null) {
                int i = ((String)href).indexOf("?");
                if (i != -1) {
                    href = ((String)href).substring(0, i);
                }
                if (!((String)href).endsWith("/")) {
                    href = (String)href + "/";
                }
                Schema schema = BaseResourceDefinition.this.getClusterController().getSchema(r.getType());
                Object id = r.getPropertyValue(schema.getKeyPropertyId(r.getType()));
                String hrefIdPart = this.urlencode(id);
                href = parent.getStringProperty("isCollection").equals("true") ? (String)href + hrefIdPart : (String)href + parent.getName() + "/" + hrefIdPart;
            }
            resultNode.setProperty("href", href);
        }

        protected String urlencode(Object id) {
            if (id == null) {
                return "";
            }
            try {
                return new URLCodec().encode(id.toString());
            }
            catch (EncoderException e) {
                return id.toString();
            }
        }
    }
}

