/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.resources;

import id.onyx.obdp.server.api.resources.BaseResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.WidgetResponse;
import id.onyx.obdp.server.controller.spi.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ActiveWidgetLayoutResourceDefinition
extends BaseResourceDefinition {
    public ActiveWidgetLayoutResourceDefinition() {
        super(Resource.Type.ActiveWidgetLayout);
    }

    @Override
    public String getPluralName() {
        return "widget_layouts";
    }

    @Override
    public String getSingularName() {
        return "widget_layout";
    }

    @Override
    public List<ResourceDefinition.PostProcessor> getPostProcessors() {
        List<ResourceDefinition.PostProcessor> listProcessors = super.getPostProcessors();
        listProcessors.add(new WidgetLayoutHrefProcessor());
        return listProcessors;
    }

    private class WidgetLayoutHrefProcessor
    extends BaseResourceDefinition.BaseHrefPostProcessor {
        private WidgetLayoutHrefProcessor() {
            super(ActiveWidgetLayoutResourceDefinition.this);
        }

        @Override
        public void process(Request request, TreeNode<Resource> resultNode, String href) {
            TreeNode<Resource> parent = resultNode.getParent();
            for (TreeNode<Resource> node : parent.getChildren()) {
                if (node.getObject().getPropertiesMap().get("WidgetLayoutInfo") != null) {
                    String layoutId = resultNode.getObject().getPropertyValue("WidgetLayoutInfo/id").toString();
                    String clusterName = resultNode.getObject().getPropertyValue("WidgetLayoutInfo/cluster_name").toString();
                    String newHref = href.substring(0, href.indexOf("/users") + 1) + "clusters/" + clusterName + "/widget_layouts/" + layoutId;
                    resultNode.setProperty("href", newHref);
                }
                if (node.getObject().getPropertiesMap().get("WidgetLayoutInfo") == null || node.getObject().getPropertiesMap().get("WidgetLayoutInfo").get("WidgetInfo") == null) continue;
                ArrayList widgetsList = (ArrayList)node.getObject().getPropertiesMap().get("WidgetLayoutInfo").get("WidgetInfo");
                for (Object widgetObject : widgetsList) {
                    HashMap widgetMap = (HashMap)widgetObject;
                    String widgetId = ((WidgetResponse)widgetMap.get("Widget")).getId().toString();
                    String clusterName = ((WidgetResponse)widgetMap.get("Widget")).getClusterName().toString();
                    String widgetHref = href.substring(0, href.indexOf("/users") + 1) + "clusters/" + clusterName + "/widgets/" + widgetId;
                    widgetMap.put("href", widgetHref);
                }
            }
        }
    }
}

