/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query.render;

import id.onyx.obdp.server.api.query.QueryInfo;
import id.onyx.obdp.server.api.query.render.BaseRenderer;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultPostProcessor;
import id.onyx.obdp.server.api.services.ResultPostProcessorImpl;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.api.util.TreeNodeImpl;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MinimalRenderer
extends BaseRenderer
implements Renderer {
    private Resource.Type m_rootType;
    private boolean m_isCollection;
    private Map<Resource.Type, Set<String>> m_originalProperties = new HashMap<Resource.Type, Set<String>>();

    @Override
    public TreeNode<Set<String>> finalizeProperties(TreeNode<QueryInfo> queryTree, boolean isCollection) {
        QueryInfo queryInfo = queryTree.getObject();
        TreeNodeImpl<Set<String>> resultTree = new TreeNodeImpl<Set<String>>(null, queryInfo.getProperties(), queryTree.getName());
        this.copyPropertiesToResult(queryTree, resultTree);
        this.m_rootType = queryTree.getObject().getResource().getType();
        this.m_isCollection = isCollection;
        boolean addKeysToEmptyResource = true;
        if (!isCollection && this.isRequestWithNoProperties(queryTree)) {
            this.addSubResources(queryTree, resultTree);
            addKeysToEmptyResource = false;
        }
        this.processRequestedProperties(queryTree);
        this.ensureRequiredProperties(resultTree, addKeysToEmptyResource);
        return resultTree;
    }

    @Override
    public Result finalizeResult(Result queryResult) {
        this.processResultNode(queryResult.getResultTree());
        return queryResult;
    }

    @Override
    public ResultPostProcessor getResultPostProcessor(Request request) {
        return new MinimalPostProcessor(request);
    }

    private void processRequestedProperties(TreeNode<QueryInfo> queryTree) {
        QueryInfo queryInfo = queryTree.getObject();
        if (queryInfo != null) {
            Resource.Type type = queryInfo.getResource().getType();
            Set<String> properties = this.m_originalProperties.get(type);
            if (properties == null) {
                properties = new HashSet<String>();
                this.m_originalProperties.put(type, properties);
            }
            properties.addAll(queryInfo.getProperties());
            for (TreeNode<QueryInfo> child : queryTree.getChildren()) {
                this.processRequestedProperties(child);
            }
        }
    }

    private void processResultNode(TreeNode<Resource> node) {
        Resource resource = node.getObject();
        if (resource != null && (resource.getType() != this.m_rootType || this.m_isCollection)) {
            Resource.Type type = resource.getType();
            Set<String> requestedProperties = this.m_originalProperties.get(type);
            Map<String, Map<String, Object>> properties = resource.getPropertiesMap();
            Iterator<Map.Entry<String, Map<String, Object>>> iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Map<String, Object>> entry = iter.next();
                String categoryName = entry.getKey();
                Iterator<String> valueIter = entry.getValue().keySet().iterator();
                while (valueIter.hasNext()) {
                    String propName = valueIter.next();
                    String absPropertyName = PropertyHelper.getPropertyId(categoryName, propName);
                    if (requestedProperties != null && (requestedProperties.contains(absPropertyName) || this.isSubCategory(requestedProperties, categoryName)) || this.getPrimaryKeys(type).contains(absPropertyName)) continue;
                    valueIter.remove();
                }
                if (!entry.getValue().isEmpty()) continue;
                iter.remove();
            }
        }
        for (TreeNode<Resource> child : node.getChildren()) {
            this.processResultNode(child);
        }
    }

    private boolean isSubCategory(Set<String> properties, String subCategoryName) {
        for (String property : properties) {
            if (!subCategoryName.startsWith(property)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getPrimaryKeys(Resource.Type type) {
        Set<String> primaryKeys = new HashSet<String>();
        if (type == Resource.Type.Configuration) {
            primaryKeys.add("type");
            primaryKeys.add("tag");
        } else {
            String pk;
            Map<Resource.Type, String> keys = PropertyHelper.getKeyPropertyIds(type);
            if (keys != null && (pk = PropertyHelper.getKeyPropertyIds(type).get(type)) != null) {
                primaryKeys = Collections.singleton(pk);
            }
        }
        return primaryKeys;
    }

    private static class MinimalPostProcessor
    extends ResultPostProcessorImpl {
        private MinimalPostProcessor(Request request) {
            super(request);
        }

        @Override
        protected void finalizeNode(TreeNode<Resource> node) {
            node.removeProperty("href");
        }
    }
}

