/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query.render;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.query.QueryInfo;
import id.onyx.obdp.server.api.query.render.BaseRenderer;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultPostProcessor;
import id.onyx.obdp.server.api.services.ResultPostProcessorImpl;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.api.util.TreeNodeImpl;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.OBDPServer;
import id.onyx.obdp.server.controller.internal.BlueprintConfigurationProcessor;
import id.onyx.obdp.server.controller.internal.BlueprintExportType;
import id.onyx.obdp.server.controller.internal.BlueprintResourceProvider;
import id.onyx.obdp.server.controller.internal.ExportBlueprintRequest;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.state.SecurityType;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.topology.AmbariContext;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.ClusterTopologyImpl;
import id.onyx.obdp.server.topology.Component;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroup;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyException;
import id.onyx.obdp.server.topology.InvalidTopologyTemplateException;
import id.onyx.obdp.server.topology.addservice.ResourceProviderAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterBlueprintRenderer
extends BaseRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterBlueprintRenderer.class);
    static final String SERVICE_SETTINGS = "service_settings";
    static final String COMPONENT_SETTINGS = "component_settings";
    static final String CREDENTIAL_STORE_ENABLED = "credential_store_enabled";
    static final String RECOVERY_ENABLED = "recovery_enabled";
    static final String TRUE = Boolean.TRUE.toString();
    static final String FALSE = Boolean.FALSE.toString();
    private final OBDPManagementController controller = OBDPServer.getController();
    private final BlueprintExportType exportType;

    public ClusterBlueprintRenderer(BlueprintExportType exportType) {
        this.exportType = exportType;
    }

    @Override
    public TreeNode<Set<String>> finalizeProperties(TreeNode<QueryInfo> queryProperties, boolean isCollection) {
        String serviceComponentType;
        TreeNode<Object> serviceComponentNode;
        TreeNode<Object> serviceNode;
        String serviceType;
        HashSet<String> properties = new HashSet<String>(queryProperties.getObject().getProperties());
        TreeNodeImpl<Set<String>> resultTree = new TreeNodeImpl<Set<String>>(null, properties, queryProperties.getName());
        this.copyPropertiesToResult(queryProperties, resultTree);
        String configType = Resource.Type.Configuration.name();
        if (resultTree.getChild(configType) == null) {
            resultTree.addChild(new HashSet(), configType);
        }
        if (resultTree.getChild(serviceType = Resource.Type.Service.name()) == null) {
            resultTree.addChild(new HashSet(), serviceType);
        }
        if ((serviceNode = resultTree.getChild(serviceType)) == null) {
            serviceNode = resultTree.addChild(new HashSet(), serviceType);
        }
        if ((serviceComponentNode = resultTree.getChild(serviceType + "/" + (serviceComponentType = Resource.Type.Component.name()))) == null) {
            serviceComponentNode = serviceNode.addChild(new HashSet(), serviceComponentType);
        }
        ((Set)serviceComponentNode.getObject()).add("ServiceComponentInfo/cluster_name");
        ((Set)serviceComponentNode.getObject()).add("ServiceComponentInfo/service_name");
        ((Set)serviceComponentNode.getObject()).add("ServiceComponentInfo/component_name");
        ((Set)serviceComponentNode.getObject()).add("ServiceComponentInfo/recovery_enabled");
        String hostType = Resource.Type.Host.name();
        String hostComponentType = Resource.Type.HostComponent.name();
        TreeNode<Object> hostComponentNode = resultTree.getChild(hostType + "/" + hostComponentType);
        if (hostComponentNode == null) {
            TreeNode hostNode = resultTree.getChild(hostType);
            if (hostNode == null) {
                hostNode = resultTree.addChild(new HashSet(), hostType);
            }
            hostComponentNode = hostNode.addChild(new HashSet(), hostComponentType);
        }
        ((Set)resultTree.getChild(configType).getObject()).add("properties");
        ((Set)hostComponentNode.getObject()).add("HostRoles/component_name");
        return resultTree;
    }

    @Override
    public Result finalizeResult(Result queryResult) {
        TreeNode<Resource> resultTree = queryResult.getResultTree();
        ResultImpl result = new ResultImpl(true);
        TreeNode<Resource> blueprintResultTree = result.getResultTree();
        if (this.isCollection(resultTree)) {
            blueprintResultTree.setProperty("isCollection", "true");
        }
        for (TreeNode<Resource> node : resultTree.getChildren()) {
            Resource blueprintResource = this.createBlueprintResource(node);
            blueprintResultTree.addChild(new TreeNodeImpl<Resource>(blueprintResultTree, blueprintResource, node.getName()));
        }
        return result;
    }

    @Override
    public ResultPostProcessor getResultPostProcessor(Request request) {
        return new BlueprintPostProcessor(request);
    }

    @Override
    public boolean requiresPropertyProviderInput() {
        return false;
    }

    private Resource createBlueprintResource(TreeNode<Resource> clusterNode) {
        Collection<Map<String, Object>> settings;
        ClusterTopology topology;
        ResourceImpl blueprintResource = new ResourceImpl(Resource.Type.Cluster);
        try {
            topology = this.createClusterTopology(clusterNode);
        }
        catch (InvalidTopologyException | InvalidTopologyTemplateException e) {
            throw new RuntimeException("Unable to process blueprint export request: " + e, e);
        }
        BlueprintConfigurationProcessor configProcessor = new BlueprintConfigurationProcessor(topology);
        configProcessor.doUpdateForBlueprintExport(this.exportType);
        Stack stack = topology.getBlueprint().getStack();
        blueprintResource.setProperty("Blueprints/stack_name", stack.getName());
        blueprintResource.setProperty("Blueprints/stack_version", stack.getVersion());
        if (topology.isClusterKerberosEnabled()) {
            LinkedHashMap<String, Object> securityConfigMap = new LinkedHashMap<String, Object>();
            securityConfigMap.put("type", SecurityType.KERBEROS.name());
            try {
                String clusterName = topology.getAmbariContext().getClusterName(topology.getClusterId());
                Map<String, Object> kerberosDescriptor = ClusterBlueprintRenderer.getKerberosDescriptor(AmbariContext.getClusterController(), clusterName);
                if (kerberosDescriptor != null) {
                    securityConfigMap.put("kerberos_descriptor", kerberosDescriptor);
                }
            }
            catch (OBDPException e) {
                LOG.info("Unable to retrieve kerberos_descriptor: ", (Object)e.getMessage());
            }
            blueprintResource.setProperty(BlueprintResourceProvider.BLUEPRINT_SECURITY_PROPERTY_ID, securityConfigMap);
        }
        List<Map<String, Object>> groupList = this.formatGroupsAsList(topology);
        blueprintResource.setProperty("host_groups", groupList);
        List<Map<String, Map<String, Map<String, ?>>>> configurations = this.processConfigurations(topology);
        if (this.exportType.include(configurations)) {
            blueprintResource.setProperty("configurations", configurations);
        }
        if (this.exportType.include(settings = this.getSettings(clusterNode, stack))) {
            blueprintResource.setProperty("settings", settings);
        }
        return blueprintResource;
    }

    @VisibleForTesting
    Collection<Map<String, Object>> getSettings(TreeNode<Resource> clusterNode, Stack stack) {
        ArrayList<Map<String, Object>> blueprintSetting = new ArrayList<Map<String, Object>>();
        HashSet serviceSettings = new HashSet();
        HashSet<ImmutableMap> componentSettings = new HashSet<ImmutableMap>();
        Collection<TreeNode<Resource>> serviceChildren = clusterNode.getChild("services").getChildren();
        for (TreeNode<Resource> serviceNode : serviceChildren) {
            ResourceImpl service = (ResourceImpl)serviceNode.getObject();
            Map<String, Object> serviceInfoMap = service.getPropertiesMap().get("ServiceInfo");
            HashMap<String, String> serviceSetting = new HashMap<String, String>();
            String serviceName = serviceInfoMap.get("service_name").toString();
            ServiceInfo serviceInfo = stack.getServiceInfo(serviceName).orElseThrow(IllegalStateException::new);
            boolean serviceDefaultCredentialStoreEnabled = serviceInfo.isCredentialStoreEnabled();
            String credentialStoreEnabledString = String.valueOf(serviceInfoMap.get(CREDENTIAL_STORE_ENABLED));
            boolean credentialStoreEnabled = Boolean.parseBoolean(credentialStoreEnabledString);
            if (credentialStoreEnabled != serviceDefaultCredentialStoreEnabled) {
                serviceSetting.put(CREDENTIAL_STORE_ENABLED, credentialStoreEnabledString);
                serviceSetting.put("name", serviceName);
                serviceSettings.add(serviceSetting);
            }
            Collection<TreeNode<Resource>> componentChildren = serviceNode.getChild("components").getChildren();
            for (TreeNode<Resource> componentNode : componentChildren) {
                String recoveryEnabledString;
                boolean recoveryEnabled;
                ResourceImpl component = (ResourceImpl)componentNode.getObject();
                Map<String, Object> serviceComponentInfoMap = component.getPropertiesMap().get("ServiceComponentInfo");
                String componentName = serviceComponentInfoMap.get("component_name").toString();
                boolean componentDefaultRecoveryEnabled = serviceInfo.getComponentByName(componentName).isRecoveryEnabled();
                if (!serviceComponentInfoMap.containsKey(RECOVERY_ENABLED) || (recoveryEnabled = Boolean.parseBoolean(recoveryEnabledString = String.valueOf(serviceComponentInfoMap.get(RECOVERY_ENABLED)))) == componentDefaultRecoveryEnabled) continue;
                componentSettings.add(ImmutableMap.of((Object)"name", (Object)componentName, (Object)RECOVERY_ENABLED, (Object)recoveryEnabledString));
            }
        }
        if (this.exportType.include(serviceSettings)) {
            blueprintSetting.add((Map<String, Object>)ImmutableMap.of((Object)SERVICE_SETTINGS, serviceSettings));
        }
        if (this.exportType.include(componentSettings)) {
            blueprintSetting.add((Map<String, Object>)ImmutableMap.of((Object)COMPONENT_SETTINGS, componentSettings));
        }
        return blueprintSetting;
    }

    private static Map<String, Object> getKerberosDescriptor(ClusterController clusterController, String clusterName) throws OBDPException {
        Resource descriptorResource;
        Map<String, Map<String, Object>> propertyMap;
        Set<Resource> response;
        Predicate predicate = ResourceProviderAdapter.predicateForKerberosDescriptorArtifact(clusterName);
        ResourceProvider artifactProvider = clusterController.ensureResourceProvider(Resource.Type.Artifact);
        RequestImpl request = new RequestImpl(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), null);
        try {
            response = artifactProvider.getResources(request, predicate);
        }
        catch (NoSuchParentResourceException | NoSuchResourceException | SystemException | UnsupportedPropertyException e) {
            throw new OBDPException("An unknown error occurred while trying to obtain the cluster kerberos descriptor", (Throwable)e);
        }
        if (response != null && !response.isEmpty() && (propertyMap = (descriptorResource = response.iterator().next()).getPropertiesMap()) != null) {
            Map<String, Object> artifactData = propertyMap.get("artifact_data");
            Map<String, Object> artifactDataProperties = propertyMap.get("artifact_data/properties");
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (artifactData != null) {
                data.putAll(artifactData);
            }
            if (artifactDataProperties != null) {
                data.put("properties", artifactDataProperties);
            }
            return data;
        }
        return null;
    }

    private List<Map<String, Map<String, Map<String, ?>>>> processConfigurations(ClusterTopology topology) {
        ArrayList configList = new ArrayList();
        Configuration configuration = topology.getConfiguration();
        Map<String, Map<String, String>> fullProperties = configuration.getFullProperties();
        Map<String, Map<String, Map<String, String>>> fullAttributes = configuration.getFullAttributes();
        ImmutableSet allTypes = ImmutableSet.builder().addAll(fullProperties.keySet()).addAll(fullAttributes.keySet()).build();
        for (String type : allTypes) {
            Map<String, Map<String, String>> attributes;
            HashMap<String, Map<String, Object>> typeMap = new HashMap<String, Map<String, Object>>();
            Map<String, String> properties = fullProperties.get(type);
            if (this.exportType.include(properties)) {
                typeMap.put("properties", properties);
            }
            if (!fullAttributes.isEmpty() && this.exportType.include(attributes = fullAttributes.get(type))) {
                typeMap.put("properties_attributes", attributes);
            }
            configList.add(Collections.singletonMap(type, typeMap));
        }
        return configList;
    }

    private List<Map<String, Object>> formatGroupsAsList(ClusterTopology topology) {
        ArrayList<Map<String, Object>> listHostGroups = new ArrayList<Map<String, Object>>();
        for (HostGroupInfo group : topology.getHostGroupInfo().values()) {
            HashMap<String, Object> mapGroupProperties = new HashMap<String, Object>();
            listHostGroups.add(mapGroupProperties);
            String name = group.getHostGroupName();
            mapGroupProperties.put("name", name);
            mapGroupProperties.put("cardinality", String.valueOf(group.getHostNames().size()));
            mapGroupProperties.put("components", this.processHostGroupComponents(topology.getBlueprint().getHostGroup(name)));
            Configuration configuration = topology.getHostGroupInfo().get(name).getConfiguration();
            ArrayList<Map<String, Map<String, String>>> configList = new ArrayList<Map<String, Map<String, String>>>();
            for (Map.Entry<String, Map<String, String>> typeEntry : configuration.getProperties().entrySet()) {
                Map<String, Map<String, String>> propertyMap = Collections.singletonMap(typeEntry.getKey(), typeEntry.getValue());
                configList.add(propertyMap);
            }
            if (!this.exportType.include(configList)) continue;
            mapGroupProperties.put("configurations", configList);
        }
        return listHostGroups;
    }

    private List<Map<String, String>> processHostGroupComponents(HostGroup group) {
        ArrayList<Map<String, String>> listHostGroupComponents = new ArrayList<Map<String, String>>();
        for (Component component : group.getComponents()) {
            HashMap<String, String> mapComponentProperties = new HashMap<String, String>();
            listHostGroupComponents.add(mapComponentProperties);
            mapComponentProperties.put("name", component.getName());
        }
        return listHostGroupComponents;
    }

    protected ClusterTopology createClusterTopology(TreeNode<Resource> clusterNode) throws InvalidTopologyTemplateException, InvalidTopologyException {
        return new ClusterTopologyImpl(new AmbariContext(), new ExportBlueprintRequest(clusterNode, this.controller));
    }

    private boolean isCollection(TreeNode<Resource> node) {
        String isCollection = node.getStringProperty("isCollection");
        return isCollection != null && isCollection.equals("true");
    }

    protected OBDPManagementController getController() {
        return this.controller;
    }

    private static class BlueprintPostProcessor
    extends ResultPostProcessorImpl {
        private BlueprintPostProcessor(Request request) {
            super(request);
        }

        @Override
        protected void finalizeNode(TreeNode<Resource> node) {
            node.removeProperty("href");
        }
    }
}

