/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query.render;

import id.onyx.obdp.server.api.query.QueryInfo;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.spi.SchemaFactory;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseRenderer
implements Renderer {
    private SchemaFactory m_schemaFactory;

    @Override
    public void init(SchemaFactory schemaFactory) {
        this.m_schemaFactory = schemaFactory;
    }

    @Override
    public boolean requiresPropertyProviderInput() {
        return true;
    }

    protected Schema getSchema(Resource.Type type) {
        return this.m_schemaFactory.getSchema(type);
    }

    protected void copyPropertiesToResult(TreeNode<QueryInfo> queryTree, TreeNode<Set<String>> propertyTree) {
        for (TreeNode<QueryInfo> node : queryTree.getChildren()) {
            TreeNode<Set<String>> child = propertyTree.addChild(node.getObject().getProperties(), node.getName());
            this.copyPropertiesToResult(node, child);
        }
    }

    protected void addPrimaryKey(Resource.Type resourceType, Set<String> properties) {
        properties.add(this.getSchema(resourceType).getKeyPropertyId(resourceType));
    }

    protected void addKeys(Resource.Type resourceType, Set<String> properties) {
        Schema schema = this.getSchema(resourceType);
        for (Resource.Type type : Resource.Type.values()) {
            String propertyId = schema.getKeyPropertyId(type);
            if (propertyId == null) continue;
            properties.add(propertyId);
        }
    }

    protected boolean isRequestWithNoProperties(TreeNode<QueryInfo> queryNode) {
        return queryNode.getChildren().isEmpty() && queryNode.getObject().getProperties().size() == 0;
    }

    protected void addSubResources(TreeNode<QueryInfo> queryTree, TreeNode<Set<String>> propertyTree) {
        QueryInfo queryInfo = queryTree.getObject();
        ResourceDefinition resource = queryInfo.getResource();
        Set<SubResourceDefinition> subResources = resource.getSubResourceDefinitions();
        for (SubResourceDefinition subResource : subResources) {
            HashSet<String> resourceProperties = new HashSet<String>();
            this.populateSubResourceDefaults(subResource, resourceProperties);
            propertyTree.addChild(resourceProperties, subResource.getType().name());
        }
    }

    protected void populateSubResourceDefaults(SubResourceDefinition subResource, Set<String> properties) {
        Schema schema = this.getSchema(subResource.getType());
        Set<Resource.Type> foreignKeys = subResource.getAdditionalForeignKeys();
        for (Resource.Type fk : foreignKeys) {
            properties.add(schema.getKeyPropertyId(fk));
        }
        this.addPrimaryKey(subResource.getType(), properties);
        this.addKeys(subResource.getType(), properties);
    }

    protected void ensureRequiredProperties(TreeNode<Set<String>> propertyTree, boolean addIfEmpty) {
        Resource.Type type = Resource.Type.valueOf(propertyTree.getName());
        Set<String> properties = propertyTree.getObject();
        if (!properties.isEmpty() || addIfEmpty) {
            this.addKeys(type, properties);
        }
        for (TreeNode<Set<String>> child : propertyTree.getChildren()) {
            this.ensureRequiredProperties(child, addIfEmpty);
        }
    }
}

