/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query.render;

import id.onyx.obdp.server.api.query.QueryInfo;
import id.onyx.obdp.server.api.query.render.AlertStateSummary;
import id.onyx.obdp.server.api.query.render.AlertStateValues;
import id.onyx.obdp.server.api.query.render.BaseRenderer;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultPostProcessor;
import id.onyx.obdp.server.api.services.ResultPostProcessorImpl;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.api.util.TreeNodeImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.MaintenanceState;
import java.util.Set;

public class AlertSummaryRenderer
extends BaseRenderer
implements Renderer {
    @Override
    public TreeNode<Set<String>> finalizeProperties(TreeNode<QueryInfo> queryTree, boolean isCollection) {
        QueryInfo queryInfo = queryTree.getObject();
        TreeNodeImpl<Set<String>> resultTree = new TreeNodeImpl<Set<String>>(null, queryInfo.getProperties(), queryTree.getName());
        this.copyPropertiesToResult(queryTree, resultTree);
        boolean addKeysToEmptyResource = true;
        if (!isCollection && this.isRequestWithNoProperties(queryTree)) {
            this.addSubResources(queryTree, resultTree);
            addKeysToEmptyResource = false;
        }
        this.ensureRequiredProperties(resultTree, addKeysToEmptyResource);
        Set properties = (Set)resultTree.getObject();
        this.addRequiredAlertProperties(properties);
        return resultTree;
    }

    @Override
    public ResultPostProcessor getResultPostProcessor(Request request) {
        return new ResultPostProcessorImpl(request);
    }

    @Override
    public Result finalizeResult(Result queryResult) {
        TreeNode<Resource> resultTree = queryResult.getResultTree();
        AlertStateSummary alertSummary = new AlertStateSummary();
        for (TreeNode<Resource> node : resultTree.getChildren()) {
            Resource resource = node.getObject();
            AlertState state = (AlertState)((Object)resource.getPropertyValue("Alert/state"));
            Long originalTimestampObject = (Long)resource.getPropertyValue("Alert/original_timestamp");
            MaintenanceState maintenanceState = (MaintenanceState)((Object)resource.getPropertyValue("Alert/maintenance_state"));
            if (null == state) {
                state = AlertState.UNKNOWN;
            }
            long originalTimestamp = 0L;
            if (null != originalTimestampObject) {
                originalTimestamp = originalTimestampObject;
            }
            boolean isMaintenanceModeEnabled = false;
            if (null != maintenanceState && maintenanceState != MaintenanceState.OFF) {
                isMaintenanceModeEnabled = true;
            }
            AlertStateValues alertStateValues = switch (state) {
                case AlertState.CRITICAL -> alertSummary.Critical;
                case AlertState.OK -> alertSummary.Ok;
                case AlertState.WARNING -> alertSummary.Warning;
                default -> alertSummary.Unknown;
            };
            if (isMaintenanceModeEnabled) {
                ++alertStateValues.MaintenanceCount;
            } else {
                ++alertStateValues.Count;
            }
            if (originalTimestamp <= alertStateValues.Timestamp) continue;
            alertStateValues.Timestamp = originalTimestamp;
        }
        ResultImpl summary = new ResultImpl(true);
        ResourceImpl resource = new ResourceImpl(Resource.Type.Alert);
        TreeNode<Resource> summaryTree = summary.getResultTree();
        summaryTree.addChild(resource, "alerts_summary");
        resource.setProperty("alerts_summary", alertSummary);
        return summary;
    }

    protected void addRequiredAlertProperties(Set<String> properties) {
        properties.add("Alert/state");
        properties.add("Alert/original_timestamp");
        properties.add("Alert/maintenance_state");
    }
}

