/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query.render;

import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.api.query.render.AlertStateSummary;
import id.onyx.obdp.server.api.query.render.AlertStateValues;
import id.onyx.obdp.server.api.query.render.AlertSummaryRenderer;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.MaintenanceState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AlertSummaryGroupedRenderer
extends AlertSummaryRenderer {
    private static final String ALERTS_SUMMARY_GROUP = "alerts_summary_grouped";

    @Override
    public Result finalizeResult(Result queryResult) {
        TreeNode<Resource> resultTree = queryResult.getResultTree();
        HashMap<String, AlertDefinitionSummary> summaries = new HashMap<String, AlertDefinitionSummary>();
        for (TreeNode<Resource> node : resultTree.getChildren()) {
            Resource resource = node.getObject();
            Long l = (Long)resource.getPropertyValue("Alert/definition_id");
            String definitionName = (String)resource.getPropertyValue("Alert/definition_name");
            AlertState state = (AlertState)((Object)resource.getPropertyValue("Alert/state"));
            Long originalTimestampObject = (Long)resource.getPropertyValue("Alert/original_timestamp");
            MaintenanceState maintenanceState = (MaintenanceState)((Object)resource.getPropertyValue("Alert/maintenance_state"));
            String alertText = (String)resource.getPropertyValue("Alert/text");
            AlertSummaryGroupedRenderer.updateSummary(summaries, l, definitionName, state, originalTimestampObject, maintenanceState, alertText);
        }
        Set entrySet = summaries.entrySet();
        ArrayList<AlertDefinitionSummary> groupedResources = new ArrayList<AlertDefinitionSummary>(entrySet.size());
        for (Map.Entry entry : entrySet) {
            groupedResources.add((AlertDefinitionSummary)entry.getValue());
        }
        ResultImpl groupedSummary = new ResultImpl(true);
        TreeNode<Resource> treeNode = groupedSummary.getResultTree();
        ResourceImpl resource = new ResourceImpl(Resource.Type.Alert);
        treeNode.addChild(resource, ALERTS_SUMMARY_GROUP);
        resource.setProperty(ALERTS_SUMMARY_GROUP, groupedResources);
        return groupedSummary;
    }

    public static void updateSummary(Map<String, AlertDefinitionSummary> summaries, Long definitionId, String definitionName, AlertState state, Long originalTimestampObject, MaintenanceState maintenanceState, String alertText) {
        AlertDefinitionSummary groupSummaryInfo;
        if (null == state) {
            state = AlertState.UNKNOWN;
        }
        long originalTimestamp = 0L;
        if (null != originalTimestampObject) {
            originalTimestamp = originalTimestampObject;
        }
        boolean isMaintenanceModeEnabled = false;
        if (null != maintenanceState && maintenanceState != MaintenanceState.OFF) {
            isMaintenanceModeEnabled = true;
        }
        if (null == (groupSummaryInfo = summaries.get(definitionName))) {
            groupSummaryInfo = new AlertDefinitionSummary();
            groupSummaryInfo.Id = definitionId;
            groupSummaryInfo.Name = definitionName;
            summaries.put(definitionName, groupSummaryInfo);
        }
        AlertStateValues alertStateValues = switch (state) {
            case AlertState.CRITICAL -> groupSummaryInfo.State.Critical;
            case AlertState.OK -> groupSummaryInfo.State.Ok;
            case AlertState.WARNING -> groupSummaryInfo.State.Warning;
            default -> groupSummaryInfo.State.Unknown;
        };
        if (isMaintenanceModeEnabled) {
            ++alertStateValues.MaintenanceCount;
        } else {
            ++alertStateValues.Count;
        }
        if (originalTimestamp > alertStateValues.Timestamp) {
            alertStateValues.Timestamp = originalTimestamp;
            alertStateValues.AlertText = alertText;
        }
    }

    public static Map<String, AlertDefinitionSummary> generateEmptySummary(Long definitionId, String definitionName) {
        HashMap<String, AlertDefinitionSummary> summaries = new HashMap<String, AlertDefinitionSummary>();
        AlertDefinitionSummary groupSummaryInfo = new AlertDefinitionSummary();
        groupSummaryInfo.Id = definitionId;
        groupSummaryInfo.Name = definitionName;
        summaries.put(definitionName, groupSummaryInfo);
        return summaries;
    }

    @Override
    protected void addRequiredAlertProperties(Set<String> properties) {
        super.addRequiredAlertProperties(properties);
        properties.add("Alert/id");
        properties.add("Alert/definition_name");
        properties.add("Alert/maintenance_state");
        properties.add("Alert/text");
    }

    public static final class AlertDefinitionSummary {
        @JsonProperty(value="definition_id")
        public long Id;
        @JsonProperty(value="definition_name")
        public String Name;
        @JsonProperty(value="summary")
        public final AlertStateSummary State = new AlertStateSummary();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AlertDefinitionSummary that = (AlertDefinitionSummary)o;
            if (this.Id != that.Id) {
                return false;
            }
            if (this.Name != null ? !this.Name.equals(that.Name) : that.Name != null) {
                return false;
            }
            return this.State != null ? this.State.equals(that.State) : that.State == null;
        }

        public int hashCode() {
            int result = (int)(this.Id ^ this.Id >>> 32);
            result = 31 * result + (this.Name != null ? this.Name.hashCode() : 0);
            result = 31 * result + (this.State != null ? this.State.hashCode() : 0);
            return result;
        }
    }
}

