/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query;

import id.onyx.obdp.server.controller.predicate.AlwaysPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.CategoryPredicate;
import id.onyx.obdp.server.controller.predicate.ComparisonPredicate;
import id.onyx.obdp.server.controller.predicate.NotPredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.predicate.UnaryPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import java.util.LinkedList;

public class SubResourcePredicateVisitor
implements PredicateVisitor {
    private Predicate lastVisited = null;
    private final String category;

    public SubResourcePredicateVisitor(String category) {
        this.category = category;
    }

    @Override
    public void acceptComparisonPredicate(ComparisonPredicate predicate) {
        String propertyId = predicate.getPropertyId();
        int index = propertyId.indexOf("/");
        String category = index == -1 ? propertyId : propertyId.substring(0, index);
        this.lastVisited = index > -1 && category.equals(this.category) ? predicate.copy(propertyId.substring(index + 1)) : AlwaysPredicate.INSTANCE;
    }

    @Override
    public void acceptArrayPredicate(ArrayPredicate arrayPredicate) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        Predicate[] predicates = arrayPredicate.getPredicates();
        if (predicates.length > 0) {
            for (Predicate predicate : predicates) {
                PredicateHelper.visit(predicate, this);
                predicateList.add(this.lastVisited);
            }
        }
        this.lastVisited = arrayPredicate.create(predicateList.toArray(new Predicate[predicateList.size()]));
    }

    @Override
    public void acceptUnaryPredicate(UnaryPredicate predicate) {
        if (predicate.getPredicate() instanceof ComparisonPredicate) {
            String category;
            ComparisonPredicate innerPredicate = (ComparisonPredicate)predicate.getPredicate();
            String propertyId = innerPredicate.getPropertyId();
            int index = propertyId.indexOf("/");
            String string = category = index == -1 ? propertyId : propertyId.substring(0, index);
            this.lastVisited = index > -1 && category.equals(this.category) ? new NotPredicate(innerPredicate.copy(propertyId.substring(index + 1))) : AlwaysPredicate.INSTANCE;
        } else {
            this.lastVisited = predicate;
        }
    }

    @Override
    public void acceptAlwaysPredicate(AlwaysPredicate predicate) {
        this.lastVisited = predicate;
    }

    @Override
    public void acceptCategoryPredicate(CategoryPredicate predicate) {
        this.lastVisited = predicate;
    }

    public Predicate getSubResourcePredicate() {
        return this.lastVisited;
    }
}

