/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query;

import id.onyx.obdp.server.api.query.ExtendedResourcePredicateVisitor;
import id.onyx.obdp.server.api.query.ProcessingPredicateVisitor;
import id.onyx.obdp.server.api.query.Query;
import id.onyx.obdp.server.api.query.QueryInfo;
import id.onyx.obdp.server.api.query.SubResourcePredicateVisitor;
import id.onyx.obdp.server.api.query.render.DefaultRenderer;
import id.onyx.obdp.server.api.query.render.Renderer;
import id.onyx.obdp.server.api.resources.ResourceDefinition;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.resources.ResourceInstanceFactoryImpl;
import id.onyx.obdp.server.api.resources.SubResourceDefinition;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.api.util.TreeNodeImpl;
import id.onyx.obdp.server.controller.internal.QueryResponseImpl;
import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.PageRequest;
import id.onyx.obdp.server.controller.spi.PageResponse;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.Schema;
import id.onyx.obdp.server.controller.spi.SortRequest;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query,
ResourceInstance {
    private final ResourceDefinition resourceDefinition;
    private final ClusterController clusterController;
    private final Set<String> requestedProperties = new HashSet<String>();
    private final Map<String, TemporalInfo> temporalInfoMap = new HashMap<String, TemporalInfo>();
    private final Map<Resource.Type, String> keyValueMap = new HashMap<Resource.Type, String>();
    private final Map<String, String> requestInfoProperties = new HashMap<String, String>();
    Map<Resource, QueryResult> queryResults = new LinkedHashMap<Resource, QueryResult>();
    Map<Resource, QueryResult> populatedQueryResults = new LinkedHashMap<Resource, QueryResult>();
    private final Map<String, QueryImpl> requestedSubResources = new HashMap<String, QueryImpl>();
    private Map<String, QueryImpl> availableSubResources;
    private boolean allProperties = false;
    private Predicate userPredicate;
    private PageRequest pageRequest;
    private SortRequest sortRequest;
    private final Set<String> subResourcePredicateProperties = new HashSet<String>();
    private Renderer renderer;
    private Predicate subResourcePredicate;
    private Predicate processedPredicate;
    private static final Logger LOG = LoggerFactory.getLogger(QueryImpl.class);

    public QueryImpl(Map<Resource.Type, String> keyValueMap, ResourceDefinition resourceDefinition, ClusterController clusterController) {
        this.resourceDefinition = resourceDefinition;
        this.clusterController = clusterController;
        this.setKeyValueMap(keyValueMap);
    }

    @Override
    public void addProperty(String propertyId, TemporalInfo temporalInfo) {
        if (propertyId.equals("*")) {
            this.addAllProperties(temporalInfo);
        } else if (!this.addPropertyToSubResource(propertyId, temporalInfo)) {
            if (propertyId.endsWith("/*")) {
                propertyId = propertyId.substring(0, propertyId.length() - 2);
            }
            this.addLocalProperty(propertyId);
            if (temporalInfo != null) {
                this.temporalInfoMap.put(propertyId, temporalInfo);
            }
        }
    }

    @Override
    public void addLocalProperty(String property) {
        this.requestedProperties.add(property);
    }

    @Override
    public Result execute() throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        this.queryForResources();
        return this.getResult(null);
    }

    @Override
    public Predicate getPredicate() {
        return this.createPredicate();
    }

    @Override
    public Set<String> getProperties() {
        return Collections.unmodifiableSet(this.requestedProperties);
    }

    @Override
    public void setUserPredicate(Predicate predicate) {
        this.userPredicate = predicate;
    }

    @Override
    public void setPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
    }

    @Override
    public void setSortRequest(SortRequest sortRequest) {
        this.sortRequest = sortRequest;
    }

    @Override
    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        renderer.init(this.clusterController);
    }

    @Override
    public void setRequestInfoProps(Map<String, String> requestInfoProperties) {
        if (requestInfoProperties != null) {
            this.requestInfoProperties.putAll(requestInfoProperties);
        }
    }

    @Override
    public Map<String, String> getRequestInfoProps() {
        return this.requestInfoProperties;
    }

    @Override
    public void setKeyValueMap(Map<Resource.Type, String> keyValueMap) {
        this.keyValueMap.putAll(keyValueMap);
    }

    @Override
    public Map<Resource.Type, String> getKeyValueMap() {
        return new HashMap<Resource.Type, String>(this.keyValueMap);
    }

    @Override
    public Query getQuery() {
        return this;
    }

    @Override
    public ResourceDefinition getResourceDefinition() {
        return this.resourceDefinition;
    }

    @Override
    public boolean isCollectionResource() {
        return this.getKeyValueMap().get(this.getResourceDefinition().getType()) == null;
    }

    @Override
    public Map<String, ResourceInstance> getSubResources() {
        return new HashMap<String, ResourceInstance>(this.ensureSubResources());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        QueryImpl query = (QueryImpl)o;
        if (!this.clusterController.equals(query.clusterController)) return false;
        if (this.pageRequest != null) {
            if (!this.pageRequest.equals(query.pageRequest)) {
                return false;
            }
        } else if (query.pageRequest != null) return false;
        if (!this.requestedProperties.equals(query.requestedProperties)) return false;
        if (!this.resourceDefinition.equals(query.resourceDefinition)) return false;
        if (!this.keyValueMap.equals(query.keyValueMap)) return false;
        if (this.userPredicate != null) {
            if (this.userPredicate.equals(query.userPredicate)) return true;
            return false;
        } else {
            if (query.userPredicate != null) return false;
            return true;
        }
    }

    public int hashCode() {
        int result = this.resourceDefinition.hashCode();
        result = 31 * result + this.clusterController.hashCode();
        result = 31 * result + this.requestedProperties.hashCode();
        result = 31 * result + this.keyValueMap.hashCode();
        result = 31 * result + (this.userPredicate != null ? this.userPredicate.hashCode() : 0);
        result = 31 * result + (this.pageRequest != null ? this.pageRequest.hashCode() : 0);
        return result;
    }

    protected Map<String, QueryImpl> ensureSubResources() {
        if (this.availableSubResources == null) {
            this.availableSubResources = new HashMap<String, QueryImpl>();
            Set<SubResourceDefinition> setSubResourceDefs = this.getResourceDefinition().getSubResourceDefinitions();
            ClusterController controller = this.clusterController;
            for (SubResourceDefinition subResDef : setSubResourceDefs) {
                Resource.Type type = subResDef.getType();
                Map<Resource.Type, String> valueMap = this.getKeyValueMap();
                QueryImpl resource = new QueryImpl(valueMap, ResourceInstanceFactoryImpl.getResourceDefinition(type, valueMap), controller);
                String subResourceName = this.getSubResourceName(resource.getResourceDefinition(), subResDef);
                this.availableSubResources.put(subResourceName, resource);
            }
        }
        return this.availableSubResources;
    }

    private boolean populateResourceRequired(Resource.Type type) {
        ResourceProvider resourceProvider = this.clusterController.ensureResourceProvider(type);
        Set<String> unsupportedProperties = resourceProvider.checkPropertyIds(PredicateHelper.getPropertyIds(this.processedPredicate));
        return !unsupportedProperties.isEmpty() || this.hasSubResourcePredicate();
    }

    private void queryForResources() throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        Resource.Type resourceType = this.getResourceDefinition().getType();
        Predicate queryPredicate = this.createPredicate(this.getKeyValueMap(), this.processUserPredicate(this.userPredicate));
        this.finalizeProperties();
        Request request = this.createRequest();
        LinkedHashSet<Resource> resourceSet = new LinkedHashSet<Resource>();
        LinkedHashSet<Resource> providerResourceSet = new LinkedHashSet<Resource>();
        QueryResponse queryResponse = this.doQuery(resourceType, request, queryPredicate, true);
        if (!(this.pageRequest == null && this.sortRequest == null || this.populateResourceRequired(resourceType))) {
            PageResponse pageResponse = this.clusterController.getPage(resourceType, queryResponse, request, queryPredicate, this.pageRequest, this.sortRequest);
            for (Resource r : pageResponse.getIterable()) {
                resourceSet.add(r);
                providerResourceSet.add(r);
            }
        } else {
            resourceSet.addAll(queryResponse.getResources());
            providerResourceSet.addAll(queryResponse.getResources());
        }
        this.populatedQueryResults.put(null, new QueryResult(request, queryPredicate, this.userPredicate, this.getKeyValueMap(), new QueryResponseImpl(resourceSet)));
        this.queryResults.put(null, new QueryResult(request, queryPredicate, this.userPredicate, this.getKeyValueMap(), queryResponse));
        if (this.renderer.requiresPropertyProviderInput()) {
            this.clusterController.populateResources(resourceType, providerResourceSet, request, queryPredicate);
        }
        if ((this.pageRequest != null || this.userPredicate != null) && !this.hasSubResourcePredicate() && this.populateResourceRequired(resourceType)) {
            QueryResponseImpl newResponse = new QueryResponseImpl(resourceSet, queryResponse.isSortedResponse(), queryResponse.isPagedResponse(), queryResponse.getTotalResourceCount());
            PageResponse pageResponse = this.clusterController.getPage(resourceType, newResponse, request, queryPredicate, this.pageRequest, this.sortRequest);
            LinkedHashSet<Resource> newResourceSet = new LinkedHashSet<Resource>();
            for (Resource r : pageResponse.getIterable()) {
                newResourceSet.add(r);
            }
            this.populatedQueryResults.put(null, new QueryResult(request, queryPredicate, this.userPredicate, this.getKeyValueMap(), new QueryResponseImpl(newResourceSet)));
        }
        this.queryForSubResources();
    }

    private void queryForSubResources() throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        for (Map.Entry<String, QueryImpl> entry : this.requestedSubResources.entrySet()) {
            QueryImpl subResource = entry.getValue();
            Resource.Type resourceType = subResource.getResourceDefinition().getType();
            Request request = subResource.createRequest();
            HashSet<Resource> providerResourceSet = new HashSet<Resource>();
            for (QueryResult queryResult : this.populatedQueryResults.values()) {
                for (Resource resource : queryResult.getQueryResponse().getResources()) {
                    Map<Resource.Type, String> map = this.getKeyValueMap(resource, queryResult.getKeyValueMap());
                    Predicate queryPredicate = subResource.createPredicate(map, subResource.processedPredicate);
                    LinkedHashSet<Resource> resourceSet = new LinkedHashSet<Resource>();
                    try {
                        Set<Resource> queryResources = subResource.doQuery(resourceType, request, queryPredicate, false).getResources();
                        providerResourceSet.addAll(queryResources);
                        resourceSet.addAll(queryResources);
                    }
                    catch (NoSuchResourceException queryResources) {
                    }
                    catch (AuthorizationException e) {
                        LOG.debug("User does not have authorization to get {} resources. The data will not be added to the response.", (Object)resourceType.name());
                    }
                    subResource.queryResults.put(resource, new QueryResult(request, queryPredicate, this.subResourcePredicate, map, new QueryResponseImpl(resourceSet)));
                    subResource.populatedQueryResults.put(resource, new QueryResult(request, queryPredicate, this.subResourcePredicate, map, new QueryResponseImpl(resourceSet)));
                }
            }
            if (this.renderer.requiresPropertyProviderInput()) {
                this.clusterController.populateResources(resourceType, providerResourceSet, request, this.subResourcePredicate);
            }
            subResource.queryForSubResources();
        }
    }

    private QueryResponse doQuery(Resource.Type type, Request request, Predicate predicate, boolean checkEmptyResponse) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing resource query: {} where {}", (Object)request, (Object)predicate);
        }
        QueryResponse queryResponse = this.clusterController.getResources(type, request, predicate);
        if (checkEmptyResponse && queryResponse.getResources().isEmpty() && !this.isCollectionResource()) {
            throw new NoSuchResourceException("The requested resource doesn't exist: " + type + " not found where " + predicate + ".");
        }
        return queryResponse;
    }

    protected Map<Resource, Set<Map<String, Object>>> getJoinedResourceProperties(Set<String> propertyIds, Resource parentResource, String category) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException, NoSuchResourceException {
        HashMap<Resource, Set<Map<String, Object>>> resourcePropertyMaps = new HashMap<Resource, Set<Map<String, Object>>>();
        Map<String, String> categoryPropertyIdMap = this.getPropertyIdsForCategory(propertyIds, category);
        for (Map.Entry<Resource, QueryResult> queryResultEntry : this.populatedQueryResults.entrySet()) {
            QueryResult queryResult = queryResultEntry.getValue();
            Resource queryParentResource = queryResultEntry.getKey();
            if (queryParentResource != parentResource) continue;
            Iterable<Resource> iterResource = this.clusterController.getIterable(this.resourceDefinition.getType(), queryResult.getQueryResponse(), queryResult.getRequest(), queryResult.getPredicate(), null, null);
            for (Resource resource : iterResource) {
                HashMap<String, Object> resourcePropertyMap = new HashMap<String, Object>();
                for (Map.Entry<String, String> categoryPropertyIdEntry : categoryPropertyIdMap.entrySet()) {
                    Object object = resource.getPropertyValue(categoryPropertyIdEntry.getValue());
                    if (object == null) continue;
                    resourcePropertyMap.put(categoryPropertyIdEntry.getKey(), object);
                }
                Set<Map<String, Object>> propertyMaps = new HashSet<Map<String, Object>>();
                for (Map.Entry<String, QueryImpl> entry : this.requestedSubResources.entrySet()) {
                    String subResourceCategory = category == null ? entry.getKey() : category + "/" + entry.getKey();
                    QueryImpl subResource = entry.getValue();
                    Map<Resource, Set<Map<String, Object>>> subResourcePropertyMaps = subResource.getJoinedResourceProperties(propertyIds, resource, subResourceCategory);
                    HashSet<Map<String, Object>> combinedSubResourcePropertyMaps = new HashSet<Map<String, Object>>();
                    for (Set<Map<String, Object>> maps : subResourcePropertyMaps.values()) {
                        combinedSubResourcePropertyMaps.addAll(maps);
                    }
                    propertyMaps = QueryImpl.joinPropertyMaps(propertyMaps, combinedSubResourcePropertyMaps);
                }
                if (!resourcePropertyMap.isEmpty()) {
                    if (propertyMaps.isEmpty()) {
                        propertyMaps.add(resourcePropertyMap);
                    } else {
                        for (Map map : propertyMaps) {
                            map.putAll(resourcePropertyMap);
                        }
                    }
                }
                resourcePropertyMaps.put(resource, propertyMaps);
            }
        }
        return resourcePropertyMaps;
    }

    private void finalizeProperties() {
        ResourceDefinition rootDefinition = this.resourceDefinition;
        QueryInfo rootQueryInfo = new QueryInfo(rootDefinition, this.requestedProperties);
        TreeNodeImpl<QueryInfo> rootNode = new TreeNodeImpl<QueryInfo>(null, rootQueryInfo, rootDefinition.getType().name());
        TreeNode<QueryInfo> requestedPropertyTree = this.buildQueryPropertyTree(this, rootNode);
        this.mergeFinalizedProperties(this.renderer.finalizeProperties(requestedPropertyTree, this.isCollectionResource()), this);
    }

    private TreeNode<QueryInfo> buildQueryPropertyTree(QueryImpl query, TreeNode<QueryInfo> node) {
        for (QueryImpl subQuery : query.requestedSubResources.values()) {
            ResourceDefinition childResource = subQuery.resourceDefinition;
            QueryInfo queryInfo = new QueryInfo(childResource, subQuery.requestedProperties);
            TreeNode<QueryInfo> childNode = node.addChild(queryInfo, childResource.getType().name());
            this.buildQueryPropertyTree(subQuery, childNode);
        }
        return node;
    }

    private void mergeFinalizedProperties(TreeNode<Set<String>> node, QueryImpl query) {
        Set<String> finalizedProperties = node.getObject();
        query.requestedProperties.clear();
        query.requestedProperties.addAll(finalizedProperties);
        for (TreeNode<Set<String>> child : node.getChildren()) {
            QueryImpl subQuery;
            Resource.Type childType = Resource.Type.valueOf(child.getName());
            ResourceDefinition parentResource = query.resourceDefinition;
            Set<SubResourceDefinition> subResources = parentResource.getSubResourceDefinitions();
            String subResourceName = null;
            for (SubResourceDefinition subResource : subResources) {
                if (subResource.getType() != childType) continue;
                ResourceDefinition resource = ResourceInstanceFactoryImpl.getResourceDefinition(subResource.getType(), query.keyValueMap);
                subResourceName = this.getSubResourceName(resource, subResource);
                break;
            }
            if ((subQuery = query.requestedSubResources.get(subResourceName)) == null) {
                query.addProperty(subResourceName, null);
                subQuery = query.requestedSubResources.get(subResourceName);
            }
            this.mergeFinalizedProperties(child, subQuery);
        }
    }

    private Map<String, String> getPropertyIdsForCategory(Set<String> propertyIds, String category) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propertyId : propertyIds) {
            if (category != null && !propertyId.startsWith(category)) continue;
            map.put(propertyId, category == null ? propertyId : propertyId.substring(category.length() + 1));
        }
        return map;
    }

    private static Set<Map<String, Object>> joinPropertyMaps(Set<Map<String, Object>> propertyMaps1, Set<Map<String, Object>> propertyMaps2) {
        HashSet<Map<String, Object>> propertyMaps = new HashSet<Map<String, Object>>();
        if (propertyMaps1.isEmpty()) {
            return propertyMaps2;
        }
        if (propertyMaps2.isEmpty()) {
            return propertyMaps1;
        }
        for (Map<String, Object> map1 : propertyMaps1) {
            for (Map<String, Object> map2 : propertyMaps2) {
                HashMap<String, Object> joinedMap = new HashMap<String, Object>(map1);
                joinedMap.putAll(map2);
                propertyMaps.add(joinedMap);
            }
        }
        return propertyMaps;
    }

    private Result getResult(Resource parentResource) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        QueryResult queryResult;
        ResultImpl result = new ResultImpl(true);
        Resource.Type resourceType = this.getResourceDefinition().getType();
        TreeNode<Resource> tree = result.getResultTree();
        if (this.isCollectionResource()) {
            tree.setProperty("isCollection", "true");
        }
        if ((queryResult = this.queryResults.get(parentResource)) != null) {
            Iterable<Resource> iterResource;
            Predicate queryPredicate = queryResult.getPredicate();
            Predicate queryUserPredicate = queryResult.getUserPredicate();
            Request queryRequest = queryResult.getRequest();
            QueryResponse queryResponse = queryResult.getQueryResponse();
            if (this.hasSubResourcePredicate() && queryUserPredicate != null) {
                queryPredicate = this.getExtendedPredicate(parentResource, queryUserPredicate);
            }
            if (this.pageRequest == null) {
                iterResource = this.clusterController.getIterable(resourceType, queryResponse, queryRequest, queryPredicate, null, this.sortRequest);
            } else {
                PageResponse pageResponse = this.clusterController.getPage(resourceType, queryResponse, queryRequest, queryPredicate, this.pageRequest, this.sortRequest);
                iterResource = pageResponse.getIterable();
                tree.setProperty("count", pageResponse.getTotalResourceCount().toString());
            }
            int count = 1;
            for (Resource resource : iterResource) {
                TreeNode<Resource> node = tree.addChild(resource, resource.getType() + ":" + count++);
                for (Map.Entry<String, QueryImpl> entry : this.requestedSubResources.entrySet()) {
                    String subResCategory = entry.getKey();
                    QueryImpl subResource = entry.getValue();
                    TreeNode<Resource> childResult = subResource.getResult(resource).getResultTree();
                    childResult.setName(subResCategory);
                    childResult.setProperty("isCollection", "false");
                    node.addChild(childResult);
                }
            }
        }
        return this.renderer.finalizeResult(result);
    }

    private boolean hasSubResourcePredicate() {
        return !this.subResourcePredicateProperties.isEmpty();
    }

    private Predicate getExtendedPredicate(Resource parentResource, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException, NoSuchResourceException {
        Map<Resource, Set<Map<String, Object>>> joinedResources = this.getJoinedResourceProperties(this.subResourcePredicateProperties, parentResource, null);
        ExtendedResourcePredicateVisitor visitor = new ExtendedResourcePredicateVisitor(joinedResources);
        PredicateHelper.visit(predicate, visitor);
        return visitor.getExtendedPredicate();
    }

    private void addAllProperties(TemporalInfo temporalInfo) {
        this.allProperties = true;
        if (temporalInfo != null) {
            this.temporalInfoMap.put(null, temporalInfo);
        }
        for (Map.Entry<String, QueryImpl> entry : this.ensureSubResources().entrySet()) {
            String name = entry.getKey();
            if (this.requestedSubResources.containsKey(name)) continue;
            this.addSubResource(name, entry.getValue());
        }
    }

    private boolean addPropertyToSubResource(String propertyId, TemporalInfo temporalInfo) {
        int index = propertyId.indexOf("/");
        String category = index == -1 ? propertyId : propertyId.substring(0, index);
        Map<String, QueryImpl> subResources = this.ensureSubResources();
        QueryImpl subResource = subResources.get(category);
        if (subResource != null) {
            this.addSubResource(category, subResource);
            if (index != -1) {
                subResource.addProperty(propertyId.substring(index + 1), temporalInfo);
            }
            return true;
        }
        return false;
    }

    private Predicate createInternalPredicate(Map<Resource.Type, String> mapResourceIds) {
        Resource.Type resourceType = this.getResourceDefinition().getType();
        Schema schema = this.clusterController.getSchema(resourceType);
        HashSet setPredicates = new HashSet();
        for (Map.Entry<Resource.Type, String> entry : mapResourceIds.entrySet()) {
            String keyPropertyId;
            if (entry.getValue() == null || (keyPropertyId = schema.getKeyPropertyId(entry.getKey())) == null) continue;
            setPredicates.add(new EqualsPredicate(keyPropertyId, (Comparable)((Object)entry.getValue())));
        }
        Predicate p = null;
        if (setPredicates.size() == 1) {
            p = (Predicate)setPredicates.iterator().next();
        } else if (setPredicates.size() > 1) {
            p = new AndPredicate(setPredicates.toArray(new Predicate[setPredicates.size()]));
        } else {
            return null;
        }
        Resource.Type type = this.getResourceDefinition().getType();
        Predicate override = this.clusterController.getAmendedPredicate(type, p);
        if (null != override) {
            p = override;
        }
        return p;
    }

    private Predicate createPredicate() {
        return this.createPredicate(this.getKeyValueMap(), this.userPredicate);
    }

    private Predicate createPredicate(Map<Resource.Type, String> keyValueMap, Predicate predicate) {
        Predicate internalPredicate = this.createInternalPredicate(keyValueMap);
        if (internalPredicate == null) {
            return predicate;
        }
        return predicate == null ? internalPredicate : new AndPredicate(predicate, internalPredicate);
    }

    private Predicate getSubResourcePredicate(Predicate predicate, String category) {
        if (predicate == null) {
            return null;
        }
        SubResourcePredicateVisitor visitor = new SubResourcePredicateVisitor(category);
        PredicateHelper.visit(predicate, visitor);
        return visitor.getSubResourcePredicate();
    }

    private Predicate processUserPredicate(Predicate predicate) {
        if (predicate == null) {
            return null;
        }
        ProcessingPredicateVisitor visitor = new ProcessingPredicateVisitor(this);
        PredicateHelper.visit(predicate, visitor);
        Set<String> categories = visitor.getSubResourceCategories();
        for (String string : categories) {
            this.addPropertyToSubResource(string, null);
        }
        this.subResourcePredicateProperties.addAll(visitor.getSubResourceProperties());
        if (this.hasSubResourcePredicate()) {
            for (Map.Entry entry : this.requestedSubResources.entrySet()) {
                this.subResourcePredicate = this.getSubResourcePredicate(predicate, (String)entry.getKey());
                ((QueryImpl)entry.getValue()).processUserPredicate(this.subResourcePredicate);
            }
        }
        this.processedPredicate = visitor.getProcessedPredicate();
        return this.processedPredicate;
    }

    private Request createRequest() {
        HashMap<String, String> requestInfoProperties = new HashMap<String, String>(this.requestInfoProperties);
        if (this.pageRequest != null) {
            requestInfoProperties.put("Request_Info/max_results", Integer.toString(this.pageRequest.getPageSize() + this.pageRequest.getOffset()));
            requestInfoProperties.put("Request_Info/asc_order", Boolean.toString(this.pageRequest.getStartingPoint() == PageRequest.StartingPoint.Beginning || this.pageRequest.getStartingPoint() == PageRequest.StartingPoint.OffsetStart));
        }
        if (this.allProperties) {
            return PropertyHelper.getReadRequest(Collections.emptySet(), requestInfoProperties, null, this.pageRequest, this.sortRequest);
        }
        HashMap<String, TemporalInfo> mapTemporalInfo = new HashMap<String, TemporalInfo>();
        TemporalInfo globalTemporalInfo = this.temporalInfoMap.get(null);
        HashSet<String> setProperties = new HashSet<String>();
        setProperties.addAll(this.requestedProperties);
        for (String propertyId : setProperties) {
            TemporalInfo temporalInfo = this.temporalInfoMap.get(propertyId);
            if (temporalInfo != null) {
                mapTemporalInfo.put(propertyId, temporalInfo);
                continue;
            }
            if (globalTemporalInfo == null) continue;
            mapTemporalInfo.put(propertyId, globalTemporalInfo);
        }
        return PropertyHelper.getReadRequest(setProperties, requestInfoProperties, mapTemporalInfo, this.pageRequest, this.sortRequest);
    }

    private Map<Resource.Type, String> getKeyValueMap(Resource resource, Map<Resource.Type, String> keyValueMap) {
        HashMap<Resource.Type, String> resourceKeyValueMap = new HashMap<Resource.Type, String>(keyValueMap.size());
        for (Map.Entry<Resource.Type, String> resourceIdEntry : keyValueMap.entrySet()) {
            Resource.Type type = resourceIdEntry.getKey();
            String value = resourceIdEntry.getValue();
            if (value == null) {
                Object o = resource.getPropertyValue(this.clusterController.getSchema(type).getKeyPropertyId(type));
                String string = value = o == null ? null : o.toString();
            }
            if (value == null) continue;
            resourceKeyValueMap.put(type, value);
        }
        Schema schema = this.clusterController.getSchema(resource.getType());
        Set<Resource.Type> types = schema.getKeyTypes();
        for (Resource.Type type : types) {
            String resourceKeyProp = schema.getKeyPropertyId(type);
            Object resourceValue = resource.getPropertyValue(resourceKeyProp);
            if (null == resourceValue) continue;
            resourceKeyValueMap.put(type, resourceValue.toString());
        }
        return resourceKeyValueMap;
    }

    private void addSubResource(String name, QueryImpl query) {
        query.setRenderer(new DefaultRenderer());
        this.requestedSubResources.put(name, query);
    }

    private String getSubResourceName(ResourceDefinition resource, SubResourceDefinition subResource) {
        return subResource.isCollection() ? resource.getPluralName() : resource.getSingularName();
    }

    private static class QueryResult {
        private final Request request;
        private final Predicate predicate;
        private final Predicate userPredicate;
        private final Map<Resource.Type, String> keyValueMap;
        private final QueryResponse queryResponse;

        private QueryResult(Request request, Predicate predicate, Predicate userPredicate, Map<Resource.Type, String> keyValueMap, QueryResponse queryResponse) {
            this.request = request;
            this.predicate = predicate;
            this.userPredicate = userPredicate;
            this.keyValueMap = keyValueMap;
            this.queryResponse = queryResponse;
        }

        public Request getRequest() {
            return this.request;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        public Predicate getUserPredicate() {
            return this.userPredicate;
        }

        public Map<Resource.Type, String> getKeyValueMap() {
            return this.keyValueMap;
        }

        public QueryResponse getQueryResponse() {
            return this.queryResponse;
        }
    }
}

