/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query;

import id.onyx.obdp.server.api.query.QueryImpl;
import id.onyx.obdp.server.controller.predicate.AlwaysPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.CategoryPredicate;
import id.onyx.obdp.server.controller.predicate.ComparisonPredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.predicate.UnaryPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ProcessingPredicateVisitor
implements PredicateVisitor {
    private final QueryImpl query;
    private Predicate lastVisited = null;
    private final Set<String> subResourceCategories = new HashSet<String>();
    private final Set<String> subResourceProperties = new HashSet<String>();

    public ProcessingPredicateVisitor(QueryImpl query) {
        this.query = query;
    }

    @Override
    public void acceptComparisonPredicate(ComparisonPredicate predicate) {
        String propertyId = predicate.getPropertyId();
        int index = propertyId.indexOf("/");
        String category = index == -1 ? propertyId : propertyId.substring(0, index);
        Map<String, QueryImpl> subResources = this.query.ensureSubResources();
        if (subResources.containsKey(category)) {
            this.subResourceCategories.add(category);
            this.subResourceProperties.add(propertyId);
            this.lastVisited = AlwaysPredicate.INSTANCE;
        } else {
            this.lastVisited = predicate;
        }
    }

    @Override
    public void acceptArrayPredicate(ArrayPredicate arrayPredicate) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        Predicate[] predicates = arrayPredicate.getPredicates();
        if (predicates.length > 0) {
            for (Predicate predicate : predicates) {
                PredicateHelper.visit(predicate, this);
                predicateList.add(this.lastVisited);
            }
        }
        this.lastVisited = arrayPredicate.create(predicateList.toArray(new Predicate[predicateList.size()]));
    }

    @Override
    public void acceptUnaryPredicate(UnaryPredicate predicate) {
        String propertyId = predicate.getPropertyIds().iterator().next();
        int index = propertyId.indexOf("/");
        String category = index == -1 ? propertyId : propertyId.substring(0, index);
        Map<String, QueryImpl> subResources = this.query.ensureSubResources();
        if (subResources.containsKey(category)) {
            this.subResourceCategories.add(category);
            this.subResourceProperties.add(propertyId);
            this.lastVisited = AlwaysPredicate.INSTANCE;
        } else {
            this.lastVisited = predicate;
        }
    }

    @Override
    public void acceptAlwaysPredicate(AlwaysPredicate predicate) {
        this.lastVisited = predicate;
    }

    @Override
    public void acceptCategoryPredicate(CategoryPredicate predicate) {
        this.lastVisited = predicate;
    }

    public Predicate getProcessedPredicate() {
        return this.lastVisited;
    }

    public Set<String> getSubResourceCategories() {
        return this.subResourceCategories;
    }

    public Set<String> getSubResourceProperties() {
        return this.subResourceProperties;
    }
}

