/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query;

import id.onyx.obdp.server.api.query.JpaPredicateVisitor;
import id.onyx.obdp.server.controller.spi.SortRequest;
import id.onyx.obdp.server.controller.spi.SortRequestProperty;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;

public class JpaSortBuilder<T> {
    public List<Order> buildSortOrders(SortRequest sortRequest, JpaPredicateVisitor<T> visitor) {
        if (null == sortRequest || null == sortRequest.getProperties()) {
            return Collections.emptyList();
        }
        CriteriaBuilder builder = visitor.getCriteriaBuilder();
        List<SortRequestProperty> sortProperties = sortRequest.getProperties();
        ArrayList<Order> sortOrders = new ArrayList<Order>(sortProperties.size());
        for (SortRequestProperty sort : sortProperties) {
            String propertyId = sort.getPropertyId();
            List<SingularAttribute<?, ?>> singularAttributes = visitor.getPredicateMapping(propertyId);
            if (null == singularAttributes || singularAttributes.size() == 0) continue;
            Path path = null;
            for (SingularAttribute<?, ?> singularAttribute : singularAttributes) {
                if (null == path) {
                    CriteriaQuery<T> query = visitor.getCriteriaQuery();
                    Set roots = query.getRoots();
                    if (null != roots && !roots.isEmpty()) {
                        for (Root root : roots) {
                            Class<T> visitorEntityClass = visitor.getEntityClass();
                            if (!ObjectUtils.equals(visitorEntityClass, (Object)root.getJavaType()) && !ObjectUtils.equals(visitorEntityClass, (Object)root.getModel().getJavaType())) continue;
                            path = root.get(singularAttribute.getName());
                            break;
                        }
                    }
                    if (null != path) continue;
                    path = query.from(visitor.getEntityClass()).get(singularAttribute.getName());
                    continue;
                }
                path = path.get(singularAttribute.getName());
            }
            Order sortOrder = null;
            sortOrder = sort.getOrder() == SortRequest.Order.ASC ? builder.asc(path) : builder.desc(path);
            sortOrders.add(sortOrder);
        }
        return sortOrders;
    }
}

