/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query;

import id.onyx.obdp.server.controller.predicate.AlwaysPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.CategoryPredicate;
import id.onyx.obdp.server.controller.predicate.ComparisonPredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.predicate.UnaryPredicate;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class JpaPredicateVisitor<T>
implements PredicateVisitor {
    private EntityManager m_entityManager;
    private CriteriaBuilder m_builder;
    private final Root<T> m_root;
    private final CriteriaQuery<T> m_query;
    private Predicate m_lastPredicate = null;
    private ArrayDeque<List<Predicate>> m_queue = new ArrayDeque();

    public JpaPredicateVisitor(EntityManager entityManager, Class<T> entityClass) {
        this.m_entityManager = entityManager;
        this.m_builder = this.m_entityManager.getCriteriaBuilder();
        this.m_query = this.m_builder.createQuery(entityClass);
        this.m_root = this.m_query.from(entityClass);
    }

    public abstract Class<T> getEntityClass();

    public abstract List<? extends SingularAttribute<?, ?>> getPredicateMapping(String var1);

    public Predicate getJpaPredicate() {
        return this.m_lastPredicate;
    }

    public CriteriaQuery<T> getCriteriaQuery() {
        return this.m_query;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.m_builder;
    }

    @Override
    public void acceptComparisonPredicate(ComparisonPredicate predicate) {
        Class clazz;
        String propertyId = predicate.getPropertyId();
        List<SingularAttribute<?, ?>> singularAttributes = this.getPredicateMapping(propertyId);
        if (null == singularAttributes || singularAttributes.size() == 0) {
            return;
        }
        SingularAttribute<?, ?> lastSingularAttribute = null;
        Path path = null;
        Iterator<SingularAttribute<?, ?>> iterator = singularAttributes.iterator();
        while (iterator.hasNext()) {
            SingularAttribute<?, ?> singularAttribute;
            lastSingularAttribute = singularAttribute = iterator.next();
            if (singularAttribute == null) continue;
            if (null == path) {
                path = this.m_root.get(singularAttribute.getName());
                continue;
            }
            path = path.get(singularAttribute.getName());
        }
        if (null == path) {
            return;
        }
        String operator = predicate.getOperator();
        Comparable value = predicate.getValue();
        if (lastSingularAttribute != null && (clazz = lastSingularAttribute.getJavaType()).isEnum()) {
            Class enumClass = clazz;
            value = Enum.valueOf(enumClass, value.toString());
        }
        Predicate jpaPredicate = null;
        if ("=".equals(operator)) {
            jpaPredicate = this.m_builder.equal((Expression)path, value);
        } else if ("<".equals(operator)) {
            jpaPredicate = this.m_builder.lessThan((Expression)path, value);
        } else if ("<=".equals(operator)) {
            jpaPredicate = this.m_builder.lessThanOrEqualTo((Expression)path, value);
        } else if (">".equals(operator)) {
            jpaPredicate = this.m_builder.greaterThan((Expression)path, value);
        } else if (">=".equals(operator)) {
            jpaPredicate = this.m_builder.greaterThanOrEqualTo((Expression)path, value);
        }
        if (null == jpaPredicate) {
            return;
        }
        if (null == this.m_queue.peekLast()) {
            this.m_lastPredicate = jpaPredicate;
        } else {
            this.m_queue.peekLast().add(jpaPredicate);
        }
    }

    @Override
    public void acceptArrayPredicate(ArrayPredicate predicate) {
        id.onyx.obdp.server.controller.spi.Predicate[] predicates = predicate.getPredicates();
        if (predicates.length == 0) {
            return;
        }
        List<Object> predicateList = new ArrayList();
        this.m_queue.add(predicateList);
        String operator = predicate.getOperator();
        for (int i = 0; i < predicates.length; ++i) {
            PredicateHelper.visit(predicates[i], this);
        }
        Predicate jpaPredicate = null;
        predicateList = this.m_queue.pollLast();
        if (predicateList != null) {
            Predicate[] array = new Predicate[predicateList.size()];
            array = predicateList.toArray(array);
            jpaPredicate = "AND".equals(operator) ? this.m_builder.and(array) : this.m_builder.or(array);
            if (null == this.m_queue.peekLast()) {
                this.m_lastPredicate = jpaPredicate;
            } else {
                this.m_queue.peekLast().add(jpaPredicate);
            }
        }
    }

    @Override
    public void acceptUnaryPredicate(UnaryPredicate predicate) {
    }

    @Override
    public void acceptAlwaysPredicate(AlwaysPredicate predicate) {
    }

    @Override
    public void acceptCategoryPredicate(CategoryPredicate predicate) {
    }
}

