/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.query;

import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.predicate.AlwaysPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.CategoryPredicate;
import id.onyx.obdp.server.controller.predicate.ComparisonPredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.predicate.UnaryPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ExtendedResourcePredicateVisitor
implements PredicateVisitor {
    private Predicate lastVisited = null;
    private final Map<Resource, Set<Map<String, Object>>> joinedResources;

    public ExtendedResourcePredicateVisitor(Map<Resource, Set<Map<String, Object>>> extendedProperties) {
        this.joinedResources = extendedProperties;
    }

    @Override
    public void acceptComparisonPredicate(ComparisonPredicate predicate) {
        this.lastVisited = new ExtendedResourcePredicate(predicate, this.joinedResources);
    }

    @Override
    public void acceptArrayPredicate(ArrayPredicate arrayPredicate) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        Predicate[] predicates = arrayPredicate.getPredicates();
        if (predicates.length > 0) {
            for (Predicate predicate : predicates) {
                PredicateHelper.visit(predicate, this);
                predicateList.add(this.lastVisited);
            }
        }
        this.lastVisited = arrayPredicate.create(predicateList.toArray(new Predicate[predicateList.size()]));
    }

    @Override
    public void acceptUnaryPredicate(UnaryPredicate predicate) {
        this.lastVisited = new ExtendedResourcePredicate(predicate, this.joinedResources);
    }

    @Override
    public void acceptAlwaysPredicate(AlwaysPredicate predicate) {
        this.lastVisited = predicate;
    }

    @Override
    public void acceptCategoryPredicate(CategoryPredicate predicate) {
        this.lastVisited = new ExtendedResourcePredicate(predicate, this.joinedResources);
    }

    public Predicate getExtendedPredicate() {
        return this.lastVisited;
    }

    private static class ExtendedResourcePredicate
    implements Predicate {
        private final Predicate predicate;
        private final Map<Resource, Set<Map<String, Object>>> joinedResources;

        public ExtendedResourcePredicate(Predicate predicate, Map<Resource, Set<Map<String, Object>>> joinedResources) {
            this.predicate = predicate;
            this.joinedResources = joinedResources;
        }

        @Override
        public boolean evaluate(Resource resource) {
            Set<Map<String, Object>> extendedPropertySet = this.joinedResources.get(resource);
            if (extendedPropertySet == null) {
                return this.predicate.evaluate(resource);
            }
            for (Map<String, Object> extendedProperties : extendedPropertySet) {
                ExtendedResourceImpl extendedResource = new ExtendedResourceImpl(resource, extendedProperties);
                if (!this.predicate.evaluate(extendedResource)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExtendedResourceImpl
    extends ResourceImpl {
        public ExtendedResourceImpl(Resource resource, Map<String, Object> extendedProperties) {
            super(resource);
            this.initProperties(extendedProperties);
        }

        private void initProperties(Map<String, Object> extendedProperties) {
            for (Map.Entry<String, Object> entry : extendedProperties.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }
}

