/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.predicate.operators;

import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.operators.EqualsOperator;
import id.onyx.obdp.server.api.predicate.operators.FilterOperator;
import id.onyx.obdp.server.api.predicate.operators.GreaterEqualsOperator;
import id.onyx.obdp.server.api.predicate.operators.GreaterOperator;
import id.onyx.obdp.server.api.predicate.operators.InOperator;
import id.onyx.obdp.server.api.predicate.operators.IsEmptyOperator;
import id.onyx.obdp.server.api.predicate.operators.LessEqualsOperator;
import id.onyx.obdp.server.api.predicate.operators.LessOperator;
import id.onyx.obdp.server.api.predicate.operators.NotEqualsOperator;
import id.onyx.obdp.server.api.predicate.operators.RelationalOperator;

public class RelationalOperatorFactory {
    public static RelationalOperator createOperator(String operator) throws InvalidQueryException {
        if ("!=".equals(operator)) {
            return new NotEqualsOperator();
        }
        if ("=".equals(operator)) {
            return new EqualsOperator();
        }
        if ("<=".equals(operator)) {
            return new LessEqualsOperator();
        }
        if ("<".equals(operator)) {
            return new LessOperator();
        }
        if (">=".equals(operator)) {
            return new GreaterEqualsOperator();
        }
        if (">".equals(operator)) {
            return new GreaterOperator();
        }
        if (".in(".equals(operator)) {
            return new InOperator();
        }
        if (".isEmpty(".equals(operator)) {
            return new IsEmptyOperator();
        }
        if (".matches(".equals(operator)) {
            return new FilterOperator();
        }
        throw new RuntimeException("Invalid Operator Type: " + operator);
    }
}

