/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.predicate.operators;

import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.operators.AbstractOperator;
import id.onyx.obdp.server.api.predicate.operators.Operator;
import id.onyx.obdp.server.api.predicate.operators.RelationalOperator;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.predicate.OrPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import java.util.ArrayList;
import java.util.List;

public class InOperator
extends AbstractOperator
implements RelationalOperator {
    public InOperator() {
        super(0);
    }

    @Override
    public String getName() {
        return "InOperator";
    }

    @Override
    public Predicate toPredicate(String prop, String val) throws InvalidQueryException {
        if (val == null) {
            throw new InvalidQueryException("IN operator is missing a required right operand for property " + prop);
        }
        String[] tokens = val.split(",");
        ArrayList<EqualsPredicate> listPredicates = new ArrayList<EqualsPredicate>();
        for (String token : tokens) {
            listPredicates.add(new EqualsPredicate(prop, token.trim()));
        }
        return listPredicates.size() == 1 ? (Predicate)listPredicates.get(0) : this.buildOrPredicate(listPredicates);
    }

    private OrPredicate buildOrPredicate(List<EqualsPredicate> listPredicates) {
        return new OrPredicate(listPredicates.toArray(new Predicate[listPredicates.size()]));
    }

    @Override
    public Operator.TYPE getType() {
        return Operator.TYPE.IN;
    }
}

