/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.predicate.expressions;

import id.onyx.obdp.server.api.predicate.expressions.Expression;
import id.onyx.obdp.server.api.predicate.operators.Operator;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExpression<T>
implements Expression<T> {
    private final Operator m_op;
    private T m_left = null;
    private T m_right = null;

    protected AbstractExpression(Operator op) {
        this.m_op = op;
    }

    @Override
    public void setLeftOperand(T left) {
        this.m_left = left;
    }

    @Override
    public void setRightOperand(T right) {
        this.m_right = right;
    }

    @Override
    public T getLeftOperand() {
        return this.m_left;
    }

    @Override
    public T getRightOperand() {
        return this.m_right;
    }

    @Override
    public Operator getOperator() {
        return this.m_op;
    }

    @Override
    public List<Expression> merge(Expression left, Expression right, int precedence) {
        return this.defaultMerge(left, right);
    }

    protected List<Expression> defaultMerge(Expression left, Expression right) {
        ArrayList<Expression> listExpressions = new ArrayList<Expression>();
        if (left != null) {
            listExpressions.add(left);
        }
        listExpressions.add(this);
        if (right != null) {
            listExpressions.add(right);
        }
        return listExpressions;
    }
}

