/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.predicate;

import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.Token;
import id.onyx.obdp.server.api.predicate.expressions.Expression;
import id.onyx.obdp.server.api.predicate.expressions.LogicalExpressionFactory;
import id.onyx.obdp.server.api.predicate.expressions.RelationalExpression;
import id.onyx.obdp.server.api.predicate.operators.LogicalOperator;
import id.onyx.obdp.server.api.predicate.operators.LogicalOperatorFactory;
import id.onyx.obdp.server.api.predicate.operators.RelationalOperator;
import id.onyx.obdp.server.api.predicate.operators.RelationalOperatorFactory;
import id.onyx.obdp.server.controller.spi.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser {
    private static final Logger LOG = LoggerFactory.getLogger(QueryParser.class);
    private static final Map<Token.TYPE, TokenHandler> TOKEN_HANDLERS = new HashMap<Token.TYPE, TokenHandler>();

    public QueryParser() {
        TOKEN_HANDLERS.put(Token.TYPE.BRACKET_OPEN, new BracketOpenTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.BRACKET_CLOSE, new BracketCloseTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.RELATIONAL_OPERATOR, new RelationalOperatorTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.LOGICAL_OPERATOR, new LogicalOperatorTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.LOGICAL_UNARY_OPERATOR, new LogicalUnaryOperatorTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.PROPERTY_OPERAND, new PropertyOperandTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.VALUE_OPERAND, new ValueOperandTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.RELATIONAL_OPERATOR_FUNC, new RelationalOperatorFuncTokenHandler());
    }

    public Predicate parse(Token[] tokens) throws InvalidQueryException {
        ParseContext ctx = this.parseExpressions(tokens);
        List<Expression> listExpressions = ctx.getExpressions();
        this.changeHostNameToLowerCase(listExpressions);
        List<Expression> listMergedExpressions = this.mergeExpressions(listExpressions, ctx.getMaxPrecedence());
        return listMergedExpressions.isEmpty() ? null : listMergedExpressions.get(0).toPredicate();
    }

    private void changeHostNameToLowerCase(List<Expression> listExpressions) {
        try {
            for (Expression expression : listExpressions) {
                String key;
                Object keyObject = expression.getLeftOperand();
                if (keyObject == null || !(key = keyObject.toString()).endsWith("/host_name") || expression.getRightOperand() == null) continue;
                expression.setRightOperand(expression.getRightOperand().toString().toLowerCase());
            }
        }
        catch (Exception e) {
            LOG.error("Lowercase host_name value in expression failed with error:" + e);
        }
    }

    private ParseContext parseExpressions(Token[] tokens) throws InvalidQueryException {
        ParseContext ctx = new ParseContext(tokens);
        while (ctx.getCurrentTokensIndex() < tokens.length) {
            TOKEN_HANDLERS.get((Object)tokens[ctx.getCurrentTokensIndex()].getType()).handleToken(ctx);
        }
        if (ctx.getPrecedenceLevel() != 0) {
            throw new InvalidQueryException("Invalid query string: mismatched parentheses.");
        }
        return ctx;
    }

    private List<Expression> mergeExpressions(List<Expression> listExpressions, int precedenceLevel) {
        if (listExpressions.size() > 1) {
            Stack<Expression> stack = new Stack<Expression>();
            stack.push(listExpressions.remove(0));
            while (!listExpressions.isEmpty()) {
                Expression exp = (Expression)stack.pop();
                Expression left = stack.empty() ? null : (Expression)stack.pop();
                Expression right = listExpressions.remove(0);
                stack.addAll(exp.merge(left, right, precedenceLevel));
            }
            return this.mergeExpressions(new ArrayList<Expression>(stack), precedenceLevel - 1);
        }
        return listExpressions;
    }

    private class BracketOpenTokenHandler
    extends TokenHandler {
        private BracketOpenTokenHandler() {
        }

        @Override
        public int _handleToken(ParseContext ctx) {
            ctx.incPrecedenceLevel(3);
            return 1;
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == null || previousTokenType == Token.TYPE.BRACKET_OPEN || previousTokenType == Token.TYPE.LOGICAL_OPERATOR || previousTokenType == Token.TYPE.LOGICAL_UNARY_OPERATOR;
        }
    }

    private class BracketCloseTokenHandler
    extends TokenHandler {
        private BracketCloseTokenHandler() {
        }

        @Override
        public int _handleToken(ParseContext ctx) throws InvalidQueryException {
            ctx.decPrecedenceLevel(3);
            return 1;
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == Token.TYPE.VALUE_OPERAND || previousTokenType == Token.TYPE.BRACKET_CLOSE;
        }
    }

    private class RelationalOperatorTokenHandler
    extends TokenHandler {
        private RelationalOperatorTokenHandler() {
        }

        @Override
        public int _handleToken(ParseContext ctx) throws InvalidQueryException {
            Token token = ctx.getTokens()[ctx.getCurrentTokensIndex()];
            RelationalOperator relationalOp = RelationalOperatorFactory.createOperator(token.getValue());
            ctx.addExpression(new RelationalExpression(relationalOp));
            return 1;
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == null || previousTokenType == Token.TYPE.BRACKET_OPEN || previousTokenType == Token.TYPE.LOGICAL_OPERATOR || previousTokenType == Token.TYPE.LOGICAL_UNARY_OPERATOR;
        }
    }

    private class LogicalOperatorTokenHandler
    extends TokenHandler {
        private LogicalOperatorTokenHandler() {
        }

        @Override
        public int _handleToken(ParseContext ctx) throws InvalidQueryException {
            Token token = ctx.getTokens()[ctx.getCurrentTokensIndex()];
            LogicalOperator logicalOp = LogicalOperatorFactory.createOperator(token.getValue(), ctx.getPrecedenceLevel());
            ctx.updateMaxPrecedence(logicalOp.getPrecedence());
            ctx.addExpression(LogicalExpressionFactory.createLogicalExpression(logicalOp));
            return 1;
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == Token.TYPE.VALUE_OPERAND || previousTokenType == Token.TYPE.BRACKET_CLOSE;
        }
    }

    private class LogicalUnaryOperatorTokenHandler
    extends LogicalOperatorTokenHandler {
        private LogicalUnaryOperatorTokenHandler() {
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == null || previousTokenType == Token.TYPE.BRACKET_OPEN || previousTokenType == Token.TYPE.LOGICAL_OPERATOR;
        }
    }

    private class PropertyOperandTokenHandler
    extends TokenHandler {
        private PropertyOperandTokenHandler() {
        }

        @Override
        public int _handleToken(ParseContext ctx) throws InvalidQueryException {
            Token token = ctx.getTokens()[ctx.getCurrentTokensIndex()];
            ctx.getPrecedingExpression().setLeftOperand(token.getValue());
            return 1;
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == Token.TYPE.RELATIONAL_OPERATOR || previousTokenType == Token.TYPE.RELATIONAL_OPERATOR_FUNC;
        }
    }

    private class ValueOperandTokenHandler
    extends TokenHandler {
        private ValueOperandTokenHandler() {
        }

        @Override
        public int _handleToken(ParseContext ctx) throws InvalidQueryException {
            Token token = ctx.getTokens()[ctx.getCurrentTokensIndex()];
            if (ctx.getPrecedingExpression() != null) {
                ctx.getPrecedingExpression().setRightOperand(token.getValue());
            }
            return 1;
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == Token.TYPE.PROPERTY_OPERAND;
        }
    }

    private class RelationalOperatorFuncTokenHandler
    extends TokenHandler {
        private RelationalOperatorFuncTokenHandler() {
        }

        @Override
        public int _handleToken(ParseContext ctx) throws InvalidQueryException {
            Token[] tokens = ctx.getTokens();
            int idx = ctx.getCurrentTokensIndex();
            Token token = tokens[idx];
            RelationalOperator relationalOp = RelationalOperatorFactory.createOperator(token.getValue());
            ctx.addExpression(new RelationalExpression(relationalOp));
            ctx.setCurrentTokensIndex(++idx);
            PropertyOperandTokenHandler propertyHandler = new PropertyOperandTokenHandler();
            propertyHandler.handleToken(ctx);
            idx = ctx.getCurrentTokensIndex();
            if (ctx.getCurrentTokensIndex() < tokens.length && tokens[idx].getType().equals((Object)Token.TYPE.VALUE_OPERAND)) {
                ValueOperandTokenHandler valueHandler = new ValueOperandTokenHandler();
                valueHandler.handleToken(ctx);
            }
            if ((idx = ctx.getCurrentTokensIndex()) >= tokens.length || tokens[idx].getType() != Token.TYPE.BRACKET_CLOSE) {
                throw new InvalidQueryException("Missing closing bracket for in expression.");
            }
            return 1;
        }

        @Override
        public boolean validate(Token.TYPE previousTokenType) {
            return previousTokenType == null || previousTokenType == Token.TYPE.BRACKET_OPEN || previousTokenType == Token.TYPE.LOGICAL_OPERATOR || previousTokenType == Token.TYPE.LOGICAL_UNARY_OPERATOR;
        }
    }

    private class ParseContext {
        private int m_precedence = 0;
        private int m_tokensIdx = 0;
        private Token[] m_tokens;
        private Token.TYPE m_previousTokenType = null;
        private List<Expression> m_listExpressions = new ArrayList<Expression>();
        int m_maxPrecedence = 0;

        public ParseContext(Token[] tokens) {
            this.m_tokens = tokens;
        }

        public Token[] getTokens() {
            return this.m_tokens;
        }

        public int getCurrentTokensIndex() {
            return this.m_tokensIdx;
        }

        public void setCurrentTokensIndex(int idx) {
            this.m_tokensIdx = idx;
        }

        public void incPrecedenceLevel(int val) {
            this.m_precedence += val;
        }

        public void decPrecedenceLevel(int val) throws InvalidQueryException {
            this.m_precedence -= val;
            if (this.m_precedence < 0) {
                throw new InvalidQueryException("Invalid query string: mismatched parentheses.");
            }
        }

        public int getPrecedenceLevel() {
            return this.m_precedence;
        }

        public List<Expression> getExpressions() {
            return this.m_listExpressions;
        }

        public Expression getPrecedingExpression() {
            return this.m_listExpressions == null ? null : this.m_listExpressions.get(this.m_listExpressions.size() - 1);
        }

        public int getMaxPrecedence() {
            return this.m_maxPrecedence;
        }

        public void updateMaxPrecedence(int precedenceLevel) {
            if (precedenceLevel > this.m_maxPrecedence) {
                this.m_maxPrecedence = precedenceLevel;
            }
        }

        public void addExpression(Expression exp) {
            this.m_listExpressions.add(exp);
        }

        private void setTokenType(Token.TYPE type) {
            this.m_previousTokenType = type;
        }

        public Token.TYPE getPreviousTokenType() {
            return this.m_previousTokenType;
        }
    }

    private abstract class TokenHandler {
        private TokenHandler() {
        }

        public void handleToken(ParseContext ctx) throws InvalidQueryException {
            Token token = ctx.getTokens()[ctx.getCurrentTokensIndex()];
            if (!this.validate(ctx.getPreviousTokenType())) {
                throw new InvalidQueryException("Unexpected token encountered in query string. Last Token Type=" + ctx.getPreviousTokenType() + ", Current Token[type=" + token.getType() + ", value='" + token.getValue() + "']");
            }
            ctx.setTokenType(token.getType());
            int idxIncrement = this._handleToken(ctx);
            ctx.setCurrentTokensIndex(ctx.getCurrentTokensIndex() + idxIncrement);
        }

        public abstract int _handleToken(ParseContext var1) throws InvalidQueryException;

        public abstract boolean validate(Token.TYPE var1);
    }
}

