/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.predicate;

import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.api.predicate.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryLexer {
    public static final String QUERY_FIELDS = "fields";
    public static final String QUERY_FORMAT = "format";
    public static final String QUERY_PAGE_SIZE = "page_size";
    public static final String QUERY_TO = "to";
    public static final String QUERY_FROM = "from";
    public static final String QUERY_MINIMAL = "minimal_response";
    public static final String QUERY_SORT = "sortBy";
    public static final String QUERY_DOAS = "doAs";
    private static final String[] ALL_DELIMS = new String[]{".matches\\(", ".in\\(", ".isEmpty\\(", "<=", ">=", "!=", "=", "<", ">", "&", "|", "!", "(", ")"};
    private static final Map<Token.TYPE, List<TokenHandler>> TOKEN_HANDLERS = new HashMap<Token.TYPE, List<TokenHandler>>();
    private static final Set<String> SET_IGNORE = new HashSet<String>();

    public QueryLexer() {
        ArrayList<TokenHandler> listHandlers = new ArrayList<TokenHandler>();
        listHandlers.add(new LogicalUnaryOperatorTokenHandler());
        listHandlers.add(new OpenBracketTokenHandler());
        listHandlers.add(new PropertyOperandTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.BRACKET_OPEN, listHandlers);
        TOKEN_HANDLERS.put(Token.TYPE.LOGICAL_OPERATOR, listHandlers);
        TOKEN_HANDLERS.put(Token.TYPE.LOGICAL_UNARY_OPERATOR, listHandlers);
        listHandlers = new ArrayList();
        listHandlers.add(new RelationalOperatorTokenHandler());
        listHandlers.add(new RelationalOperatorFuncTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.PROPERTY_OPERAND, listHandlers);
        listHandlers = new ArrayList();
        listHandlers.add(new ValueOperandTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.RELATIONAL_OPERATOR, listHandlers);
        listHandlers = new ArrayList();
        listHandlers.add(new CloseBracketTokenHandler());
        listHandlers.add(new ComplexValueOperandTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.RELATIONAL_OPERATOR_FUNC, listHandlers);
        listHandlers = new ArrayList();
        listHandlers.add(new CloseBracketTokenHandler());
        listHandlers.add(new LogicalOperatorTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.BRACKET_CLOSE, listHandlers);
        listHandlers = new ArrayList(listHandlers);
        listHandlers.add(0, new ComplexValueOperandTokenHandler());
        TOKEN_HANDLERS.put(Token.TYPE.VALUE_OPERAND, listHandlers);
    }

    public Token[] tokens(String exp) throws InvalidQueryException {
        return this.tokens(exp, Collections.emptySet());
    }

    public Token[] tokens(String exp, Collection<String> ignoreProperties) throws InvalidQueryException {
        ScanContext ctx = new ScanContext();
        ctx.addPropertiesToIgnore(SET_IGNORE);
        ctx.addPropertiesToIgnore(ignoreProperties);
        for (String tok : this.parseStringTokens(exp)) {
            List<TokenHandler> listHandlers = TOKEN_HANDLERS.get((Object)ctx.getLastTokenType());
            boolean processed = false;
            int idx = 0;
            while (!processed && idx < listHandlers.size()) {
                processed = listHandlers.get(idx++).handleToken(tok, ctx);
            }
            if (processed) continue;
            throw new InvalidQueryException("Invalid Query Token: token='" + tok + "', previous token type=" + ctx.getLastTokenType());
        }
        ctx.validateEndState();
        return ctx.getTokenList().toArray(new Token[ctx.getTokenList().size()]);
    }

    private List<String> parseStringTokens(String exp) {
        Pattern pattern = this.generatePattern();
        Matcher matcher = pattern.matcher(exp);
        ArrayList<String> listStrTokens = new ArrayList<String>();
        int pos = 0;
        while (matcher.find()) {
            if (pos != matcher.start()) {
                listStrTokens.add(exp.substring(pos, matcher.start()));
            }
            listStrTokens.add(matcher.group());
            pos = matcher.end();
        }
        if (pos != exp.length()) {
            listStrTokens.add(exp.substring(pos));
        }
        return listStrTokens;
    }

    private Pattern generatePattern() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (String delim : ALL_DELIMS) {
            if (sb.length() != 1) {
                sb.append('|');
            }
            sb.append('\\');
            sb.append(delim);
        }
        sb.append(')');
        return Pattern.compile(sb.toString());
    }

    static {
        SET_IGNORE.add(QUERY_FIELDS);
        SET_IGNORE.add(QUERY_FORMAT);
        SET_IGNORE.add(QUERY_PAGE_SIZE);
        SET_IGNORE.add(QUERY_TO);
        SET_IGNORE.add(QUERY_FROM);
        SET_IGNORE.add(QUERY_MINIMAL);
        SET_IGNORE.add(QUERY_SORT);
        SET_IGNORE.add(QUERY_DOAS);
        SET_IGNORE.add("_");
    }

    private class LogicalUnaryOperatorTokenHandler
    extends TokenHandler {
        private LogicalUnaryOperatorTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            ctx.addToken(new Token(Token.TYPE.LOGICAL_UNARY_OPERATOR, token));
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.LOGICAL_UNARY_OPERATOR;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return "!".equals(token);
        }
    }

    private class OpenBracketTokenHandler
    extends TokenHandler {
        private OpenBracketTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            ctx.addToken(new Token(Token.TYPE.BRACKET_OPEN, token));
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.BRACKET_OPEN;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return token.matches("\\(");
        }
    }

    private class PropertyOperandTokenHandler
    extends TokenHandler {
        private PropertyOperandTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            if (!ctx.getPropertiesToIgnore().contains(token)) {
                ctx.setPropertyOperand(token);
            } else if (!ctx.getTokenList().isEmpty()) {
                ctx.setIgnoreSegmentEndToken(Token.TYPE.VALUE_OPERAND);
                ctx.getTokenList().remove(ctx.getTokenList().size() - 1);
            } else {
                ctx.setIgnoreSegmentEndToken(Token.TYPE.LOGICAL_OPERATOR);
            }
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.PROPERTY_OPERAND;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return token.matches("[^!&\\|<=|>=|!=|=|<|>\\(\\)]+");
        }
    }

    private class RelationalOperatorTokenHandler
    extends TokenHandler {
        private RelationalOperatorTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            ctx.addToken(new Token(Token.TYPE.RELATIONAL_OPERATOR, token));
            ctx.addToken(new Token(Token.TYPE.PROPERTY_OPERAND, ctx.getPropertyOperand()));
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.RELATIONAL_OPERATOR;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return token.matches("<=|>=|!=|=|<|>");
        }
    }

    private class RelationalOperatorFuncTokenHandler
    extends TokenHandler {
        private RelationalOperatorFuncTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            ctx.addToken(new Token(Token.TYPE.RELATIONAL_OPERATOR_FUNC, token));
            ctx.addToken(new Token(Token.TYPE.PROPERTY_OPERAND, ctx.getPropertyOperand()));
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.RELATIONAL_OPERATOR_FUNC;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return token.matches("\\.[a-zA-Z]+\\(");
        }
    }

    private class ValueOperandTokenHandler
    extends TokenHandler {
        private ValueOperandTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            ctx.addToken(new Token(Token.TYPE.VALUE_OPERAND, token));
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.VALUE_OPERAND;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return token.matches("[^!&\\|<=|>=|!=|=|<|>]+");
        }
    }

    private class CloseBracketTokenHandler
    extends TokenHandler {
        private CloseBracketTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            ctx.addToken(new Token(Token.TYPE.BRACKET_CLOSE, token));
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.BRACKET_CLOSE;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return token.matches("\\)");
        }
    }

    private class ComplexValueOperandTokenHandler
    extends TokenHandler {
        private ComplexValueOperandTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            if (token.equals(")")) {
                ctx.decrementBracketScore(1);
            } else if (token.endsWith("(")) {
                ctx.incrementBracketScore(1);
            }
            Object tokenValue = token;
            if (ctx.getBracketScore() > 0) {
                Token lastToken;
                Deque<Token> intermediateTokens = ctx.getIntermediateTokens();
                if (intermediateTokens != null && !intermediateTokens.isEmpty() && (lastToken = intermediateTokens.peek()).getType() == Token.TYPE.VALUE_OPERAND) {
                    intermediateTokens.pop();
                    tokenValue = lastToken.getValue() + token;
                }
                ctx.pushIntermediateToken(new Token(Token.TYPE.VALUE_OPERAND, (String)tokenValue));
            }
            if (ctx.getBracketScore() == 0) {
                ctx.addIntermediateTokens();
                ctx.addToken(new Token(Token.TYPE.BRACKET_CLOSE, ")"));
            }
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.VALUE_OPERAND;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            Token.TYPE lastTokenType = ctx.getLastTokenType();
            if (lastTokenType == Token.TYPE.RELATIONAL_OPERATOR_FUNC) {
                ctx.incrementBracketScore(1);
                return true;
            }
            return ctx.getBracketScore() > 0;
        }

        @Override
        public void validateEndState(ScanContext ctx) throws InvalidQueryException {
            if (ctx.getBracketScore() > 0) {
                throw new InvalidQueryException("Missing closing bracket for function: " + ctx.getTokenList());
            }
        }
    }

    private class LogicalOperatorTokenHandler
    extends TokenHandler {
        private LogicalOperatorTokenHandler() {
        }

        @Override
        public void _handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            ctx.addToken(new Token(Token.TYPE.LOGICAL_OPERATOR, token));
        }

        @Override
        public Token.TYPE getType() {
            return Token.TYPE.LOGICAL_OPERATOR;
        }

        @Override
        public boolean handles(String token, ScanContext ctx) {
            return token.matches("[!&\\|]");
        }
    }

    private class ScanContext {
        private Token.TYPE m_lastType;
        private String m_propertyName;
        private List<Token> m_listTokens = new ArrayList<Token>();
        private Token.TYPE m_ignoreSegmentEndToken = null;
        private Set<String> m_propertiesToIgnore = new HashSet<String>();
        private int bracketScore = 0;
        private Deque<Token> m_intermediateTokens = new ArrayDeque<Token>();

        private ScanContext() {
            this.m_lastType = Token.TYPE.LOGICAL_OPERATOR;
        }

        public void setIgnoreSegmentEndToken(Token.TYPE type) {
            this.m_ignoreSegmentEndToken = type;
        }

        public Token.TYPE getLastTokenType() {
            return this.m_lastType;
        }

        public void setLastTokenType(Token.TYPE lastType) {
            this.m_lastType = lastType;
        }

        public String getPropertyOperand() {
            return this.m_propertyName;
        }

        public void setPropertyOperand(String prop) {
            this.m_propertyName = prop;
        }

        public void addToken(Token token) {
            if (this.m_ignoreSegmentEndToken == null) {
                this.m_listTokens.add(token);
            } else if (token.getType() == this.m_ignoreSegmentEndToken) {
                this.m_ignoreSegmentEndToken = null;
            }
        }

        public List<Token> getTokenList() {
            return this.m_listTokens;
        }

        public Set<String> getPropertiesToIgnore() {
            return this.m_propertiesToIgnore;
        }

        public void addPropertiesToIgnore(Collection<String> ignoredProperties) {
            if (ignoredProperties != null) {
                this.m_propertiesToIgnore.addAll(ignoredProperties);
            }
        }

        public void pushIntermediateToken(Token token) {
            if (this.m_ignoreSegmentEndToken == null) {
                this.m_intermediateTokens.add(token);
            } else if (token.getType() == this.m_ignoreSegmentEndToken) {
                this.m_ignoreSegmentEndToken = null;
            }
        }

        public Deque<Token> getIntermediateTokens() {
            return this.m_intermediateTokens;
        }

        public void addIntermediateTokens() {
            this.m_listTokens.addAll(this.m_intermediateTokens);
            this.m_intermediateTokens.clear();
        }

        public int getBracketScore() {
            return this.bracketScore;
        }

        public int incrementBracketScore(int n) {
            return this.bracketScore += n;
        }

        public int decrementBracketScore(int decValue) throws InvalidQueryException {
            this.bracketScore -= decValue;
            if (this.bracketScore < 0) {
                throw new InvalidQueryException("Unexpected closing bracket.  Last token type: " + this.getLastTokenType() + ", Current property operand: " + this.getPropertyOperand() + ", tokens: " + this.getTokenList());
            }
            return this.bracketScore;
        }

        public void validateEndState() throws InvalidQueryException {
            for (TokenHandler handler : TOKEN_HANDLERS.get((Object)this.getLastTokenType())) {
                handler.validateEndState(this);
            }
        }
    }

    private abstract class TokenHandler {
        private TokenHandler() {
        }

        public boolean handleToken(String token, ScanContext ctx) throws InvalidQueryException {
            if (this.handles(token, ctx)) {
                this._handleToken(token, ctx);
                ctx.setLastTokenType(this.getType());
                return true;
            }
            return false;
        }

        public void validateEndState(ScanContext ctx) throws InvalidQueryException {
            if (!ctx.getIntermediateTokens().isEmpty()) {
                throw new InvalidQueryException("Unexpected end of expression.");
            }
        }

        public abstract void _handleToken(String var1, ScanContext var2) throws InvalidQueryException;

        public abstract Token.TYPE getType();

        public abstract boolean handles(String var1, ScanContext var2);
    }
}

