/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.handlers;

import id.onyx.obdp.server.api.handlers.RequestHandler;
import id.onyx.obdp.server.api.query.Query;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.TemporalInfo;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadHandler
implements RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReadHandler.class);

    @Override
    public Result handleRequest(Request request) {
        Result result;
        Query query = request.getResource().getQuery();
        query.setPageRequest(request.getPageRequest());
        query.setSortRequest(request.getSortRequest());
        query.setRenderer(request.getRenderer());
        RequestBody body = request.getBody();
        if (body != null) {
            query.setRequestInfoProps(body.getRequestInfoProperties());
        }
        try {
            this.addFieldsToQuery(request, query);
        }
        catch (IllegalArgumentException e) {
            return new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, e.getMessage()));
        }
        Predicate p = null;
        try {
            p = request.getQueryPredicate();
            query.setUserPredicate(p);
            result = query.execute();
            result.setResultStatus(new ResultStatus(ResultStatus.STATUS.OK));
        }
        catch (AuthorizationException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.FORBIDDEN, e.getMessage()));
        }
        catch (SystemException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.SERVER_ERROR, e));
        }
        catch (NoSuchParentResourceException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.NOT_FOUND, e.getMessage()));
        }
        catch (UnsupportedPropertyException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, e.getMessage()));
        }
        catch (NoSuchResourceException e) {
            if (p == null) {
                result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.NOT_FOUND, e.getMessage()));
            } else {
                result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.OK, e));
                result.getResultTree().setProperty("isCollection", "true");
            }
        }
        catch (IllegalArgumentException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, "Invalid Request: " + e.getMessage()));
            LOG.error("Bad request: ", (Throwable)e);
        }
        catch (RuntimeException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Caught a runtime exception executing a query", (Throwable)e);
            }
            throw e;
        }
        return result;
    }

    private void addFieldsToQuery(Request request, Query query) {
        for (Map.Entry<String, TemporalInfo> entry : request.getFields().entrySet()) {
            String propertyId = entry.getKey();
            query.addProperty(propertyId, entry.getValue());
        }
    }
}

