/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.handlers;

import id.onyx.obdp.server.api.handlers.BaseManagementHandler;
import id.onyx.obdp.server.api.handlers.ReadHandler;
import id.onyx.obdp.server.api.handlers.RequestHandler;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.resources.ResourceInstanceFactory;
import id.onyx.obdp.server.api.resources.ResourceInstanceFactoryImpl;
import id.onyx.obdp.server.api.services.NamedPropertySet;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultMetadata;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.RequestStatusMetaData;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryCreateHandler
extends BaseManagementHandler {
    private RequestHandler m_readHandler = new ReadHandler();

    @Override
    public Result handleRequest(Request request) {
        Map<Resource.Type, Set<Map<String, Object>>> mapProperties;
        Result queryResult = this.getReadHandler().handleRequest(request);
        if (queryResult.getStatus().isErrorState() || queryResult.getResultTree().getChildren().isEmpty()) {
            return queryResult;
        }
        try {
            mapProperties = this.buildCreateSet(request, queryResult);
        }
        catch (IllegalArgumentException e) {
            return this.createInvalidRequestResult(e.getMessage());
        }
        if (mapProperties.size() != 1) {
            return this.createInvalidRequestResult(mapProperties.size() == 0 ? "A minimum of one sub-resource must be specified for creation." : "Multiple sub-resource types may not be created in the same request.");
        }
        Map.Entry<Resource.Type, Set<Map<String, Object>>> entry = mapProperties.entrySet().iterator().next();
        ResourceInstance createResource = this.getResourceFactory().createResource(entry.getKey(), request.getResource().getKeyValueMap());
        RequestBody requestBody = new RequestBody();
        requestBody.setBody(request.getBody().getBody());
        for (Map<String, Object> map : entry.getValue()) {
            requestBody.addPropertySet(new NamedPropertySet("", map));
        }
        return this.persist(createResource, requestBody);
    }

    private Map<Resource.Type, Set<Map<String, Object>>> buildCreateSet(Request request, Result queryResult) throws IllegalArgumentException {
        Set<NamedPropertySet> setRequestProps = request.getBody().getNamedPropertySets();
        HashMap<Resource.Type, Set<Map<String, Object>>> mapProps = new HashMap<Resource.Type, Set<Map<String, Object>>>();
        ResourceInstance resource = request.getResource();
        Resource.Type type = resource.getResourceDefinition().getType();
        ClusterController controller = this.getClusterController();
        String resourceKeyProperty = controller.getSchema(type).getKeyPropertyId(type);
        TreeNode<Resource> tree = queryResult.getResultTree();
        Collection<TreeNode<Resource>> treeChildren = tree.getChildren();
        for (TreeNode<Resource> node : treeChildren) {
            Resource r = node.getObject();
            Object keyVal = r.getPropertyValue(resourceKeyProperty);
            for (NamedPropertySet namedProps : setRequestProps) {
                for (Map.Entry<String, Object> entry : namedProps.getProperties().entrySet()) {
                    Set set = (Set)entry.getValue();
                    for (Map map : set) {
                        HashMap<String, Object> mapResourceProps = new HashMap<String, Object>(map);
                        Resource.Type createType = this.getCreateType(resource, entry.getKey());
                        mapResourceProps.put(controller.getSchema(createType).getKeyPropertyId(resource.getResourceDefinition().getType()), keyVal);
                        Set<Map<String, Object>> setCreateProps = mapProps.get(createType);
                        if (setCreateProps == null) {
                            setCreateProps = new HashSet<Map<String, Object>>();
                            mapProps.put(createType, setCreateProps);
                        }
                        setCreateProps.add(mapResourceProps);
                    }
                }
            }
        }
        return mapProps;
    }

    private Resource.Type getCreateType(ResourceInstance resource, String subResourceName) throws IllegalArgumentException {
        if (subResourceName == null || subResourceName.equals("")) {
            throw new IllegalArgumentException("A sub-resource name must be supplied.");
        }
        ResourceInstance res = resource.getSubResources().get(subResourceName);
        if (res == null) {
            throw new IllegalArgumentException("The specified sub-resource name is not valid: '" + subResourceName + "'.");
        }
        return res.getResourceDefinition().getType();
    }

    private Result createInvalidRequestResult(String msg) {
        return new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, "Invalid Request: " + msg));
    }

    @Override
    protected Result persist(ResourceInstance resource, RequestBody body) {
        Result result;
        try {
            RequestStatus status = this.getPersistenceManager().create(resource, body);
            result = this.createResult(status);
            if (result.isSynchronous()) {
                if (resource.getResourceDefinition().isCreatable()) {
                    result.setResultStatus(new ResultStatus(ResultStatus.STATUS.CREATED));
                } else {
                    result.setResultStatus(new ResultStatus(ResultStatus.STATUS.OK));
                }
            } else {
                result.setResultStatus(new ResultStatus(ResultStatus.STATUS.ACCEPTED));
            }
        }
        catch (AuthorizationException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.FORBIDDEN, e.getMessage()));
        }
        catch (UnsupportedPropertyException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, e));
        }
        catch (ResourceAlreadyExistsException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.CONFLICT, e));
        }
        catch (NoSuchParentResourceException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.NOT_FOUND, e));
        }
        catch (SystemException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.SERVER_ERROR, e));
        }
        return result;
    }

    @Override
    protected ResultMetadata convert(RequestStatusMetaData requestStatusMetaData) {
        if (requestStatusMetaData == null) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    protected ResourceInstanceFactory getResourceFactory() {
        return new ResourceInstanceFactoryImpl();
    }

    protected RequestHandler getReadHandler() {
        return this.m_readHandler;
    }
}

