/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.handlers;

import id.onyx.obdp.server.ConfigGroupNotFoundException;
import id.onyx.obdp.server.api.handlers.BaseManagementHandler;
import id.onyx.obdp.server.api.handlers.RequestHandler;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.DeleteResultMetadata;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultMetadata;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.controller.internal.DeleteStatusMetaData;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.RequestStatusMetaData;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.security.authorization.AuthorizationException;

public class DeleteHandler
extends BaseManagementHandler
implements RequestHandler {
    @Override
    protected Result persist(ResourceInstance resource, RequestBody body) {
        Result result;
        try {
            RequestStatus status = this.getPersistenceManager().delete(resource, body);
            result = this.createResult(status);
            if (result.isSynchronous()) {
                result.setResultStatus(new ResultStatus(ResultStatus.STATUS.OK));
            } else {
                result.setResultStatus(new ResultStatus(ResultStatus.STATUS.ACCEPTED));
            }
        }
        catch (AuthorizationException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.FORBIDDEN, e.getMessage()));
        }
        catch (SystemException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.SERVER_ERROR, e));
        }
        catch (NoSuchParentResourceException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.NOT_FOUND, e));
        }
        catch (NoSuchResourceException e) {
            result = resource.isCollectionResource() ? new ResultImpl(new ResultStatus(ResultStatus.STATUS.OK, e)) : (e.getCause() instanceof ConfigGroupNotFoundException ? new ResultImpl(new ResultStatus(ResultStatus.STATUS.ACCEPTED, e)) : new ResultImpl(new ResultStatus(ResultStatus.STATUS.NOT_FOUND, e)));
        }
        catch (UnsupportedPropertyException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, e));
        }
        return result;
    }

    @Override
    protected ResultMetadata convert(RequestStatusMetaData requestStatusMetaData) {
        if (requestStatusMetaData == null) {
            return null;
        }
        if (!(requestStatusMetaData instanceof DeleteStatusMetaData)) {
            throw new IllegalArgumentException(String.format("Wrong status details class received - expecting: %s; actual: %s", DeleteStatusMetaData.class, requestStatusMetaData.getClass()));
        }
        DeleteStatusMetaData statusDetails = (DeleteStatusMetaData)requestStatusMetaData;
        DeleteResultMetadata resultDetails = new DeleteResultMetadata();
        resultDetails.addDeletedKeys(statusDetails.getDeletedKeys());
        resultDetails.addExceptions(statusDetails.getExceptionForKeys());
        return resultDetails;
    }
}

