/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.handlers;

import id.onyx.obdp.server.api.handlers.BaseManagementHandler;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultMetadata;
import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.controller.internal.OperationStatusMetaData;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.RequestStatusMetaData;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateHandler
extends BaseManagementHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CreateHandler.class);

    @Override
    protected Result persist(ResourceInstance resource, RequestBody body) {
        Result result;
        try {
            RequestStatus status = this.getPersistenceManager().create(resource, body);
            result = this.createResult(status);
            if (result.isSynchronous()) {
                if (resource.getResourceDefinition().isCreatable()) {
                    result.setResultStatus(new ResultStatus(ResultStatus.STATUS.CREATED));
                } else {
                    result.setResultStatus(new ResultStatus(ResultStatus.STATUS.OK));
                }
            } else {
                result.setResultStatus(new ResultStatus(ResultStatus.STATUS.ACCEPTED));
            }
        }
        catch (AuthorizationException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.FORBIDDEN, e.getMessage()));
        }
        catch (UnsupportedPropertyException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, e.getMessage()));
            LOG.error("Bad request received: " + e.getMessage());
        }
        catch (NoSuchParentResourceException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.NOT_FOUND, e.getMessage()));
        }
        catch (SystemException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Caught a system exception while attempting to create a resource: {}", (Object)e.getMessage(), (Object)e);
            }
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.SERVER_ERROR, e.getMessage()));
        }
        catch (ResourceAlreadyExistsException e) {
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.CONFLICT, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Bad request received: " + e.getMessage(), (Throwable)e);
            result = new ResultImpl(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, e.getMessage()));
        }
        catch (RuntimeException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Caught a runtime exception while attempting to create a resource: {}", (Object)e.getMessage(), (Object)e);
            }
            throw e;
        }
        return result;
    }

    @Override
    protected ResultMetadata convert(RequestStatusMetaData requestStatusMetaData) {
        if (requestStatusMetaData == null) {
            return null;
        }
        if (requestStatusMetaData.getClass() == OperationStatusMetaData.class) {
            return (OperationStatusMetaData)requestStatusMetaData;
        }
        throw new IllegalArgumentException(String.format("RequestStatusDetails is of an expected type: %s", requestStatusMetaData.getClass().getName()));
    }
}

