/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api.handlers;

import id.onyx.obdp.server.api.handlers.RequestHandler;
import id.onyx.obdp.server.api.query.Query;
import id.onyx.obdp.server.api.resources.ResourceInstance;
import id.onyx.obdp.server.api.services.Request;
import id.onyx.obdp.server.api.services.RequestBody;
import id.onyx.obdp.server.api.services.Result;
import id.onyx.obdp.server.api.services.ResultImpl;
import id.onyx.obdp.server.api.services.ResultMetadata;
import id.onyx.obdp.server.api.services.persistence.PersistenceManager;
import id.onyx.obdp.server.api.services.persistence.PersistenceManagerImpl;
import id.onyx.obdp.server.api.util.TreeNode;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.RequestStatusMetaData;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import java.util.Set;

public abstract class BaseManagementHandler
implements RequestHandler {
    public static final String RESOURCES_NODE_NAME = "resources";
    PersistenceManager m_pm = new PersistenceManagerImpl(this.getClusterController());

    protected BaseManagementHandler() {
    }

    @Override
    public Result handleRequest(Request request) {
        Query query = request.getResource().getQuery();
        Predicate queryPredicate = request.getQueryPredicate();
        query.setRenderer(request.getRenderer());
        if (queryPredicate != null) {
            query.setUserPredicate(queryPredicate);
        }
        return this.persist(request.getResource(), request.getBody());
    }

    protected Result createResult(RequestStatus requestStatus) {
        Set<Resource> setResources;
        boolean isSynchronous = requestStatus.getStatus() == RequestStatus.Status.Complete;
        ResultImpl result = new ResultImpl(isSynchronous);
        TreeNode<Resource> tree = result.getResultTree();
        if (!isSynchronous) {
            tree.addChild(requestStatus.getRequestResource(), "request");
        }
        if (!(setResources = requestStatus.getAssociatedResources()).isEmpty()) {
            TreeNode<Object> resourcesNode = tree.addChild(null, RESOURCES_NODE_NAME);
            resourcesNode.setProperty("isCollection", "true");
            int count = 1;
            for (Resource resource : setResources) {
                resourcesNode.addChild(resource, resource.getType() + ":" + count++);
            }
        }
        result.setResultMetadata(this.convert(requestStatus.getStatusMetadata()));
        return result;
    }

    protected ClusterController getClusterController() {
        return ClusterControllerHelper.getClusterController();
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_pm;
    }

    protected abstract Result persist(ResourceInstance var1, RequestBody var2);

    protected abstract ResultMetadata convert(RequestStatusMetaData var1);
}

