/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api;

import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserNameOverrideFilter
implements Filter {
    private static final Pattern USER_NAME_IN_URI_REGEXP = Pattern.compile("(?<pre>.*/users/)(?<username>[^/]+)(?<post>(/.*)?)");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String userName;
        String userNameFromUri;
        HttpServletRequest httpServletRequest;
        Matcher userNameMatcher;
        if (request instanceof HttpServletRequest && (userNameMatcher = this.getUserNameMatcher((httpServletRequest = (HttpServletRequest)request).getRequestURI())).find() && !(userNameFromUri = URLDecoder.decode(userNameMatcher.group("username"), "UTF-8")).equals(userName = AuthorizationHelper.resolveLoginAliasToUserName(userNameFromUri))) {
            final String requestUriOverride = String.format("%s%s%s", userNameMatcher.group("pre"), userName, userNameMatcher.group("post"));
            request = new HttpServletRequestWrapper(httpServletRequest){

                public String getRequestURI() {
                    return requestUriOverride;
                }
            };
        }
        chain.doFilter(request, response);
    }

    protected Matcher getUserNameMatcher(String requestUri) {
        return USER_NAME_IN_URI_REGEXP.matcher(requestUri);
    }

    public void destroy() {
    }
}

