/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api;

import id.onyx.obdp.server.api.OBDPErrorHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBDPViewErrorHandlerProxy
extends ErrorHandler
implements MethodHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDPViewErrorHandlerProxy.class);
    private final ErrorHandler webAppErrorHandler;
    private final OBDPErrorHandler ambariErrorHandler;

    public OBDPViewErrorHandlerProxy(ErrorHandler webAppErrorHandler, OBDPErrorHandler ambariErrorHandler) {
        this.webAppErrorHandler = webAppErrorHandler;
        this.ambariErrorHandler = ambariErrorHandler;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isInternalError(request, response)) {
            this.ambariErrorHandler.handle(target, baseRequest, request, response);
        } else {
            this.webAppErrorHandler.handle(target, baseRequest, request, response);
        }
    }

    private boolean isInternalError(HttpServletRequest request, HttpServletResponse response) {
        Throwable th = (Throwable)request.getAttribute("jakarta.servlet.error.exception");
        return null != th && response.getStatus() == 500;
    }

    public void setShowStacks(boolean showStacks) {
        this.ambariErrorHandler.setShowStacks(showStacks);
        this.webAppErrorHandler.setShowStacks(showStacks);
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        LOGGER.debug("invoked method: " + thisMethod.getName());
        Method m = this.findDeclaredMethod(((Object)((Object)this)).getClass(), thisMethod);
        if (m != null) {
            return m.invoke((Object)this, args);
        }
        m = this.findMethod(this.webAppErrorHandler.getClass(), thisMethod);
        if (m != null) {
            return m.invoke((Object)this.webAppErrorHandler, args);
        }
        return null;
    }

    private Method findDeclaredMethod(Class<?> clazz, Method method) {
        try {
            return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Method findMethod(Class<?> clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

