/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import id.onyx.obdp.server.security.authentication.jwt.JwtAuthenticationProperties;
import id.onyx.obdp.server.security.authentication.jwt.JwtAuthenticationPropertiesProvider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBDPErrorHandler
extends ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPErrorHandler.class);
    private final Gson gson;
    private JwtAuthenticationPropertiesProvider jwtAuthenticationPropertiesProvider;

    @Inject
    public OBDPErrorHandler(@Named(value="prettyGson") Gson prettyGson, JwtAuthenticationPropertiesProvider jwtAuthenticationPropertiesProvider) {
        this.gson = prettyGson;
        this.jwtAuthenticationPropertiesProvider = jwtAuthenticationPropertiesProvider;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JwtAuthenticationProperties jwtProperties;
        HttpChannel connection = HttpConnection.getCurrentConnection().getHttpChannel();
        connection.getRequest().setHandled(true);
        response.setContentType(MimeTypes.Type.TEXT_PLAIN.asString());
        LinkedHashMap<String, Object> errorMap = new LinkedHashMap<String, Object>();
        int code = connection.getResponse().getStatus();
        errorMap.put("status", code);
        Object message = connection.getResponse().getReason();
        if (message == null) {
            message = HttpStatus.getMessage((int)code);
        }
        errorMap.put("message", message);
        Throwable th = (Throwable)request.getAttribute("jakarta.servlet.error.exception");
        if (th != null) {
            if (code == 500) {
                UUID requestId = UUID.randomUUID();
                message = "Internal server error, please refer the exception by " + requestId + " in the server log file";
                errorMap.put("message", message);
                LOG.error((String)message + ", requestURI: " + request.getRequestURI(), th);
            }
            if (this.isShowStacks()) {
                StringWriter writer = new StringWriter();
                this.writeErrorPageStacks(request, writer);
                errorMap.put("reason:", writer.toString());
            }
        }
        if ((code == 403 || code == 401) && (jwtProperties = (JwtAuthenticationProperties)this.jwtAuthenticationPropertiesProvider.get()) != null && jwtProperties.isEnabledForAmbari()) {
            String providerUrl = jwtProperties.getAuthenticationProviderUrl();
            String originalUrl = jwtProperties.getOriginalUrlQueryParam();
            if (StringUtils.isEmpty((String)providerUrl)) {
                LOG.warn("The SSO provider URL is not available, forwarding to the SSO provider is not possible");
            } else if (StringUtils.isEmpty((String)originalUrl)) {
                LOG.warn("The original URL parameter name is not available, forwarding to the SSO provider is not possible");
            } else {
                errorMap.put("jwtProviderUrl", String.format("%s?%s=", providerUrl, originalUrl));
            }
        }
        this.gson.toJson(errorMap, (Appendable)response.getWriter());
    }

    protected void writeErrorPageStacks(HttpServletRequest request, Writer writer) throws IOException {
        for (Throwable th = (Throwable)request.getAttribute("jakarta.servlet.error.exception"); th != null; th = th.getCause()) {
            writer.write("Caused by:\n");
            this.write(writer, ExceptionUtils.getStackTrace((Throwable)th));
            writer.write("\n");
        }
    }
}

