/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpMethod;

public class MethodOverrideFilter
implements Filter {
    private static final String HEADER_NAME = "X-Http-Method-Override";
    private static final List<String> ALLOWED_METHODS = new ArrayList<String>(){
        {
            this.add("GET");
        }
    };

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        String method;
        if (request instanceof HttpServletRequest && (method = (httpServletRequest = (HttpServletRequest)request).getHeader(HEADER_NAME)) != null) {
            if (ALLOWED_METHODS.contains(method.toUpperCase())) {
                final HttpMethod httpMethod = HttpMethod.valueOf((String)method.toUpperCase());
                HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(httpServletRequest){

                    public String getMethod() {
                        return httpMethod.toString();
                    }
                };
                chain.doFilter((ServletRequest)requestWrapper, response);
                return;
            }
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(400, "Incorrect HTTP method for override: " + method + ". Allowed values: " + ALLOWED_METHODS);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

