/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Path;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeOverrideFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ContentTypeOverrideFilter.class);
    private final Set<Pattern> excludedUrls = new HashSet<Pattern>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        String contentType;
        if (request instanceof HttpServletRequest && (contentType = (httpServletRequest = (HttpServletRequest)request).getContentType()) != null && contentType.startsWith("application/json") && !this.isUrlExcluded(httpServletRequest.getPathInfo())) {
            ContentTypeOverrideRequestWrapper requestWrapper = new ContentTypeOverrideRequestWrapper(httpServletRequest);
            ContentTypeOverrideResponseWrapper responseWrapper = new ContentTypeOverrideResponseWrapper((HttpServletResponse)response);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            return;
        }
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            ClassPath classPath = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader());
            ImmutableSet classes = classPath.getTopLevelClassesRecursive("id.onyx.obdp.server.api");
            block5: for (ClassPath.ClassInfo classInfo : classes) {
                Class clazz = classInfo.load();
                if (!clazz.isAnnotationPresent(Path.class)) continue;
                Path path = clazz.getAnnotation(Path.class);
                for (Method method : clazz.getMethods()) {
                    if (!method.isAnnotationPresent(Consumes.class)) continue;
                    Consumes consumesAnnotation = method.getAnnotation(Consumes.class);
                    for (String consume : consumesAnnotation.value()) {
                        if (!"application/json".equals(consume)) continue;
                        this.excludedUrls.add(Pattern.compile(path.value()));
                        continue block5;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to discover URLs that are excluded from Content-Type override. Falling back to pre-defined list of exluded URLs.", (Throwable)e);
            this.excludedUrls.add(Pattern.compile("/bootstrap"));
        }
        finally {
            this.excludedUrls.add(Pattern.compile("/views/.*"));
        }
    }

    private boolean isUrlExcluded(String pathInfo) {
        return this.excludedUrls.stream().anyMatch(p -> p.matcher(pathInfo).matches());
    }

    public void destroy() {
    }

    class ContentTypeOverrideRequestWrapper
    extends HttpServletRequestWrapper {
        public ContentTypeOverrideRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public Enumeration<String> getHeaders(String name) {
            Enumeration headerValues = super.getHeaders(name);
            if ("Content-Type".equals(name)) {
                HashSet<String> newContentTypeValues = new HashSet<String>();
                while (headerValues.hasMoreElements()) {
                    String value = (String)headerValues.nextElement();
                    if (value != null && value.startsWith("application/json")) {
                        newContentTypeValues.add(value.replace("application/json", "text/plain"));
                        continue;
                    }
                    newContentTypeValues.add(value);
                }
                return Collections.enumeration(newContentTypeValues);
            }
            return headerValues;
        }

        public String getHeader(String name) {
            String header;
            if ("Content-Type".equals(name) && (header = super.getHeader(name)) != null && header.startsWith("application/json")) {
                return header.replace("application/json", "text/plain");
            }
            return super.getHeader(name);
        }
    }

    class ContentTypeOverrideResponseWrapper
    extends HttpServletResponseWrapper {
        public ContentTypeOverrideResponseWrapper(HttpServletResponse response) {
            super(response);
            super.setContentType("application/json");
        }

        public void setHeader(String name, String value) {
            if (!"Content-Type".equals(name)) {
                super.setHeader(name, value);
            }
        }

        public void addHeader(String name, String value) {
            if (!"Content-Type".equals(name)) {
                super.addHeader(name, value);
            }
        }

        public void setContentType(String type) {
        }
    }
}

