/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.DestinationVariableMethodArgumentResolver;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.support.MissingSessionUserException;
import org.springframework.messaging.simp.annotation.support.SendToMethodReturnValueHandler;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PropertyPlaceholderHelper;

public class AmbariSendToMethodReturnValueHandler
extends SendToMethodReturnValueHandler {
    private final SimpMessageSendingOperations messagingTemplate;
    private final boolean annotationRequired;
    private PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("{", "}", null, false);
    private String defaultUserDestinationPrefix = "/queue";
    private String defaultDestinationPrefix = "/topic";
    public static final String CORRELATION_ID_HEADER = "correlationId";
    public static final String NATIVE_HEADERS = "nativeHeaders";

    public AmbariSendToMethodReturnValueHandler(SimpMessageSendingOperations messagingTemplate, boolean annotationRequired) {
        super(messagingTemplate, annotationRequired);
        this.messagingTemplate = messagingTemplate;
        this.annotationRequired = annotationRequired;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        if (returnValue == null) {
            return;
        }
        MessageHeaders headers = message.getHeaders();
        String sessionId = SimpMessageHeaderAccessor.getSessionId((Map)headers);
        PropertyPlaceholderHelper.PlaceholderResolver varResolver = this.initVarResolver(headers);
        Object annotation = this.findAnnotation(returnType);
        String correlationId = this.getCorrelationId(message);
        if (annotation != null && annotation instanceof SendToUser) {
            String[] destinations;
            SendToUser sendToUser = (SendToUser)annotation;
            boolean broadcast = sendToUser.broadcast();
            String user = this.getUserName(message, headers);
            if (user == null) {
                if (sessionId == null) {
                    throw new MissingSessionUserException(message);
                }
                user = sessionId;
                broadcast = false;
            }
            for (String destination : destinations = this.getTargetDestinations((Annotation)sendToUser, message, this.defaultUserDestinationPrefix)) {
                destination = this.placeholderHelper.replacePlaceholders(destination, varResolver);
                if (broadcast) {
                    this.messagingTemplate.convertAndSendToUser(user, destination, returnValue, (Map)this.createHeaders(null, returnType, correlationId));
                    continue;
                }
                this.messagingTemplate.convertAndSendToUser(user, destination, returnValue, (Map)this.createHeaders(sessionId, returnType, correlationId));
            }
        } else {
            String[] destinations;
            SendTo sendTo = (SendTo)annotation;
            for (String destination : destinations = this.getTargetDestinations((Annotation)sendTo, message, this.defaultDestinationPrefix)) {
                destination = this.placeholderHelper.replacePlaceholders(destination, varResolver);
                this.messagingTemplate.convertAndSend((Object)destination, returnValue, (Map)this.createHeaders(sessionId, returnType, correlationId));
            }
        }
    }

    private String getCorrelationId(Message<?> message) {
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.wrap(message);
        return headerAccessor.getFirstNativeHeader(CORRELATION_ID_HEADER);
    }

    private MessageHeaders createHeaders(String sessionId, MethodParameter returnType, String correlationId) {
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.create((SimpMessageType)SimpMessageType.MESSAGE);
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders((MessageHeaderAccessor)headerAccessor);
        }
        if (sessionId != null) {
            headerAccessor.setSessionId(sessionId);
        }
        headerAccessor.setHeader("conversionHint", (Object)returnType);
        headerAccessor.setLeaveMutable(true);
        headerAccessor.addNativeHeader(CORRELATION_ID_HEADER, correlationId);
        return headerAccessor.getMessageHeaders();
    }

    private Object findAnnotation(MethodParameter returnType) {
        Annotation[] anns = new Annotation[]{AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getMethod(), SendToUser.class), AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getMethod(), SendTo.class), AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendToUser.class), AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)returnType.getDeclaringClass(), SendTo.class)};
        if (anns[0] != null && !ObjectUtils.isEmpty((Object[])((SendToUser)anns[0]).value())) {
            return anns[0];
        }
        if (anns[1] != null && !ObjectUtils.isEmpty((Object[])((SendTo)anns[1]).value())) {
            return anns[1];
        }
        if (anns[2] != null && !ObjectUtils.isEmpty((Object[])((SendToUser)anns[2]).value())) {
            return anns[2];
        }
        if (anns[3] != null && !ObjectUtils.isEmpty((Object[])((SendTo)anns[3]).value())) {
            return anns[3];
        }
        for (int i = 0; i < 4; ++i) {
            if (anns[i] == null) continue;
            return anns[i];
        }
        return null;
    }

    private PropertyPlaceholderHelper.PlaceholderResolver initVarResolver(MessageHeaders headers) {
        String name = DestinationVariableMethodArgumentResolver.DESTINATION_TEMPLATE_VARIABLES_HEADER;
        Map vars = (Map)headers.get((Object)name);
        return new DestinationVariablePlaceholderResolver(vars);
    }

    public String toString() {
        return "AmbariSendToMethodReturnValueHandler [annotationRequired=" + this.annotationRequired + "]";
    }

    private static class DestinationVariablePlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Map<String, String> vars;

        public DestinationVariablePlaceholderResolver(Map<String, String> vars) {
            this.vars = vars;
        }

        public String resolvePlaceholder(String placeholderName) {
            return this.vars != null ? this.vars.get(placeholderName) : null;
        }
    }
}

