/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.api;

import id.onyx.obdp.server.api.services.ResultStatus;
import id.onyx.obdp.server.api.services.serializers.JsonSerializer;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AmbariCsrfProtectionFilter
implements ContainerRequestFilter {
    private static final Set<String> IGNORED_METHODS;
    private static final String CSRF_HEADER = "X-Requested-By";
    private static final String ERROR_MESSAGE = "CSRF protection is turned on. X-Requested-By HTTP header is required.";
    private static final JsonSerializer JSON_SERIALIZER;

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (!IGNORED_METHODS.contains(containerRequestContext.getMethod()) && !containerRequestContext.getHeaders().containsKey((Object)CSRF_HEADER)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(JSON_SERIALIZER.serializeError(new ResultStatus(ResultStatus.STATUS.BAD_REQUEST, ERROR_MESSAGE))).type(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }

    static {
        JSON_SERIALIZER = new JsonSerializer();
        HashSet<String> methods = new HashSet<String>();
        methods.add("GET");
        methods.add("OPTIONS");
        methods.add("HEAD");
        IGNORED_METHODS = Collections.unmodifiableSet(methods);
    }
}

