/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.alerts;

import id.onyx.obdp.server.state.AlertState;
import javax.annotation.Nullable;

public class Threshold {
    private final Double okValue;
    private final double warnValue;
    private final double critValue;

    public Threshold(@Nullable Double okValue, double warnValue, double critValue) {
        this.okValue = okValue;
        this.warnValue = warnValue;
        this.critValue = critValue;
    }

    public AlertState state(double value) {
        return this.directionUp() ? this.stateWhenDirectionUp(value) : this.stateWhenDirectionDown(value);
    }

    private boolean directionUp() {
        return this.critValue >= this.warnValue;
    }

    private AlertState stateWhenDirectionUp(double value) {
        if (value >= this.critValue) {
            return AlertState.CRITICAL;
        }
        if (value >= this.warnValue) {
            return AlertState.WARNING;
        }
        if (this.okValue == null || value >= this.okValue) {
            return AlertState.OK;
        }
        return AlertState.UNKNOWN;
    }

    private AlertState stateWhenDirectionDown(double value) {
        if (value <= this.critValue) {
            return AlertState.CRITICAL;
        }
        if (value <= this.warnValue) {
            return AlertState.WARNING;
        }
        if (this.okValue == null || value <= this.okValue) {
            return AlertState.OK;
        }
        return AlertState.UNKNOWN;
    }
}

