/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.alerts;

import com.google.inject.Inject;
import id.onyx.obdp.server.agent.stomp.AlertDefinitionsHolder;
import id.onyx.obdp.server.alerts.AlertRunnable;
import id.onyx.obdp.server.events.AlertDefinitionsAgentUpdateEvent;
import id.onyx.obdp.server.orm.dao.AlertsDAO;
import id.onyx.obdp.server.orm.entities.AlertCurrentEntity;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.AlertHistoryEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostState;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.SourceType;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleAlertRunnable
extends AlertRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(StaleAlertRunnable.class);
    private static final String ALL_ALERTS_CURRENT_MSG = "All alerts have run within their time intervals.";
    private static final String STALE_ALERTS_MSG = "There are {0} stale alerts from {1} host(s):\n{2}";
    private static final String TIMED_LABEL_MSG = "{0} ({1})";
    private static final String HOST_LABEL_MSG = "{0}\n  [{1}]";
    private static final long MINUTE_TO_MS_CONVERSION = 60000L;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int MINUTES_PER_HOUR = 60;
    @Inject
    private AlertsDAO m_alertsDao;
    @Inject
    private AlertDefinitionFactory m_definitionFactory;
    @Inject
    private AlertDefinitionsHolder alertDefinitionsHolder;

    public StaleAlertRunnable(String definitionName) {
        super(definitionName);
    }

    @Override
    List<Alert> execute(Cluster cluster, AlertDefinitionEntity myDefinition) {
        AlertDefinition alertDefinition = this.m_definitionFactory.coerce(myDefinition);
        int waitFactor = this.alertHelper.getWaitFactorMultiplier(alertDefinition);
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        long uptime = rb.getUptime();
        int totalStaleAlerts = 0;
        TreeSet<String> staleAlertGroupings = new TreeSet<String>();
        HashMap staleAlertsByHost = new HashMap();
        TreeSet<String> hostsWithStaleAlerts = new TreeSet<String>();
        List<AlertCurrentEntity> currentAlerts = this.m_alertsDao.findCurrentByCluster(cluster.getClusterId());
        long now = System.currentTimeMillis();
        Map<Long, List<Long>> alertDefinitionsToHosts = this.prepareHostDefinitions(cluster.getClusterId());
        for (AlertCurrentEntity current : currentAlerts) {
            Boolean timedout;
            long intervalInMillis;
            AlertHistoryEntity history = current.getAlertHistory();
            AlertDefinitionEntity currentDefinition = history.getAlertDefinition();
            if (currentDefinition.getSourceType() == SourceType.AGGREGATE || current.getMaintenanceState() != MaintenanceState.OFF || current.getLatestTimestamp() == 0L || currentDefinition.getDefinitionName().equals(this.m_definitionName) || uptime <= (long)waitFactor * (intervalInMillis = (long)currentDefinition.getScheduleInterval().intValue() * 60000L)) continue;
            Long lastCheckTimestamp = 0L;
            String currentHostName = history.getHostName();
            List<Host> hosts = new ArrayList<Host>();
            if (currentHostName != null) {
                hosts.add(cluster.getHost(currentHostName));
            } else if (alertDefinitionsToHosts.containsKey(current.getDefinitionId())) {
                hosts = alertDefinitionsToHosts.get(current.getDefinitionId()).stream().map(i -> cluster.getHost((Long)i)).collect(Collectors.toList());
            }
            if (!hosts.isEmpty()) {
                timedout = true;
                for (Host host : hosts) {
                    if (!timedout.booleanValue()) continue;
                    if (this.alertHelper.getStaleAlerts(host.getHostId()).containsKey(current.getDefinitionId())) {
                        lastCheckTimestamp = Math.max(lastCheckTimestamp, this.alertHelper.getStaleAlerts(host.getHostId()).get(current.getDefinitionId()));
                        continue;
                    }
                    if (host.getState().equals((Object)HostState.HEARTBEAT_LOST)) {
                        lastCheckTimestamp = Math.max(lastCheckTimestamp, host.getLastHeartbeatTime());
                        continue;
                    }
                    timedout = false;
                }
            } else {
                long timeDifference = now - current.getLatestTimestamp();
                timedout = timeDifference >= (long)waitFactor * intervalInMillis;
                lastCheckTimestamp = current.getOriginalTimestamp();
            }
            if (!timedout.booleanValue()) continue;
            ++totalStaleAlerts;
            String label = currentDefinition.getLabel();
            if (StringUtils.isEmpty((String)label)) {
                label = currentDefinition.getDefinitionName();
            }
            if (null != history.getHostName()) {
                String hostName = history.getHostName();
                hostsWithStaleAlerts.add(hostName);
                if (!staleAlertsByHost.containsKey(hostName)) {
                    staleAlertsByHost.put(hostName, new TreeSet());
                }
                long timeDifference = now - lastCheckTimestamp;
                ((Set)staleAlertsByHost.get(hostName)).add(MessageFormat.format(TIMED_LABEL_MSG, label, StaleAlertRunnable.millisToHumanReadableStr(timeDifference)));
                continue;
            }
            staleAlertGroupings.add(label);
        }
        for (String host : staleAlertsByHost.keySet()) {
            staleAlertGroupings.add(MessageFormat.format(HOST_LABEL_MSG, host, StringUtils.join((Collection)((Collection)staleAlertsByHost.get(host)), (String)",\n  ")));
        }
        AlertState alertState = AlertState.OK;
        String alertText = ALL_ALERTS_CURRENT_MSG;
        if (!staleAlertGroupings.isEmpty()) {
            alertState = AlertState.CRITICAL;
            alertText = MessageFormat.format(STALE_ALERTS_MSG, totalStaleAlerts, hostsWithStaleAlerts.size(), StringUtils.join(staleAlertGroupings, (String)",\n"));
        }
        Alert alert = new Alert(myDefinition.getDefinitionName(), null, myDefinition.getServiceName(), myDefinition.getComponentName(), null, alertState);
        alert.setLabel(myDefinition.getLabel());
        alert.setText(alertText);
        alert.setTimestamp(now);
        alert.setClusterId(cluster.getClusterId());
        return Collections.singletonList(alert);
    }

    public Map<Long, List<Long>> prepareHostDefinitions(Long clusterId) {
        HashMap<Long, List<Long>> alertDefinitionsToHosts = new HashMap<Long, List<Long>>();
        this.alertDefinitionsHolder.getData().entrySet().stream().filter(e -> ((AlertDefinitionsAgentUpdateEvent)e.getValue()).getClusters() != null).filter(e -> ((AlertDefinitionsAgentUpdateEvent)e.getValue()).getClusters().get(clusterId) != null).forEach(e -> ((AlertDefinitionsAgentUpdateEvent)e.getValue()).getClusters().get(clusterId).getAlertDefinitions().stream().forEach(l -> {
            alertDefinitionsToHosts.putIfAbsent(l.getDefinitionId(), new ArrayList());
            ((List)alertDefinitionsToHosts.get(l.getDefinitionId())).add((Long)e.getKey());
        }));
        return alertDefinitionsToHosts;
    }

    private static String millisToHumanReadableStr(long milliseconds) {
        int min = (int)(milliseconds / 60000L);
        int days = min / 1440;
        int hour = (min %= 1440) / 60;
        min %= 60;
        Object result = "";
        if (days > 0) {
            result = (String)result + days + "d ";
        }
        if (hour > 0) {
            result = (String)result + hour + "h ";
        }
        if (min > 0) {
            result = (String)result + min + "m ";
        }
        return ((String)result).trim();
    }
}

