/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.alerts;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.RequestStatus;
import id.onyx.obdp.server.alerts.AlertRunnable;
import id.onyx.obdp.server.api.query.QueryImpl;
import id.onyx.obdp.server.api.query.render.MinimalRenderer;
import id.onyx.obdp.server.api.resources.ClusterResourceDefinition;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationToken;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.ParameterizedSource;
import id.onyx.obdp.server.state.alert.ServerSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class OBDPPerformanceRunnable
extends AlertRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPPerformanceRunnable.class);
    private static final String PERFORMANCE_OVERVIEW_TEMPLATE = "Performance Overview:" + System.lineSeparator() + "{0}";
    private static final String PERFORMANCE_AREA_TEMPLATE = "  {0}: {1}ms ({2})";
    private static final String PERFORMANCE_AREA_FAILURE_TEMPLATE = "  Unable to execute performance alert area {0}: ({1})";
    @Inject
    private AlertDefinitionFactory m_definitionFactory;
    @Inject
    private RequestDAO m_requestDAO;
    @Inject
    private HostRoleCommandDAO m_hostRoleCommandDAO;
    @Inject
    private ActionManager m_actionManager;

    public OBDPPerformanceRunnable(String definitionName) {
        super(definitionName);
    }

    @Override
    List<Alert> execute(Cluster cluster, AlertDefinitionEntity entity) throws OBDPException {
        AlertDefinition definition = this.m_definitionFactory.coerce(entity);
        ServerSource serverSource = (ServerSource)definition.getSource();
        List<ParameterizedSource.AlertParameter> parameters = serverSource.getParameters();
        ArrayList<String> results = new ArrayList<String>();
        AlertState alertState = AlertState.OK;
        block9: for (PerformanceArea performanceArea : PerformanceArea.values()) {
            PerformanceResult performanceResult;
            try {
                long startTime = System.currentTimeMillis();
                performanceArea.execute(this, cluster);
                long totalTime = System.currentTimeMillis() - startTime;
                performanceResult = this.calculatePerformanceResult(performanceArea, totalTime, parameters);
            }
            catch (Exception exception) {
                String result = MessageFormat.format(PERFORMANCE_AREA_FAILURE_TEMPLATE, new Object[]{performanceArea, AlertState.UNKNOWN});
                LOG.error(result, (Throwable)exception);
                performanceResult = new PerformanceResult(result, AlertState.UNKNOWN);
            }
            String result = performanceResult.getResult();
            AlertState resultAlertState = performanceResult.getAlertState();
            results.add(result);
            switch (resultAlertState) {
                case CRITICAL: {
                    alertState = AlertState.CRITICAL;
                    continue block9;
                }
                case OK: {
                    continue block9;
                }
                case SKIPPED: {
                    continue block9;
                }
                case UNKNOWN: {
                    if (alertState != AlertState.OK) continue block9;
                    alertState = AlertState.UNKNOWN;
                    continue block9;
                }
                case WARNING: {
                    if (alertState == AlertState.CRITICAL) continue block9;
                    alertState = AlertState.WARNING;
                    continue block9;
                }
            }
        }
        String allResults = StringUtils.join(results, (String)System.lineSeparator());
        String overview = MessageFormat.format(PERFORMANCE_OVERVIEW_TEMPLATE, allResults);
        Alert alert = new Alert(entity.getDefinitionName(), null, entity.getServiceName(), entity.getComponentName(), null, alertState);
        alert.setLabel(entity.getLabel());
        alert.setText(overview);
        alert.setTimestamp(System.currentTimeMillis());
        alert.setClusterId(cluster.getClusterId());
        return Collections.singletonList(alert);
    }

    PerformanceResult calculatePerformanceResult(PerformanceArea area, long time, List<ParameterizedSource.AlertParameter> parameters) {
        AlertState alertState = AlertState.OK;
        int warningThreshold = area.m_defaultWarningThreshold;
        int criticalThreshold = area.m_defaultCriticalThreshold;
        for (ParameterizedSource.AlertParameter parameter : parameters) {
            Object value = parameter.getValue();
            if (StringUtils.equals((String)parameter.getName(), (String)area.m_warningParameter)) {
                warningThreshold = this.alertHelper.getThresholdValue(value, warningThreshold);
            }
            if (!StringUtils.equals((String)parameter.getName(), (String)area.m_criticalParameter)) continue;
            criticalThreshold = this.alertHelper.getThresholdValue(value, criticalThreshold);
        }
        if (time >= (long)warningThreshold && time < (long)criticalThreshold) {
            alertState = AlertState.WARNING;
        }
        if (time >= (long)criticalThreshold) {
            alertState = AlertState.CRITICAL;
        }
        String resultLabel = MessageFormat.format(PERFORMANCE_AREA_TEMPLATE, new Object[]{area.m_label, time, alertState});
        return new PerformanceResult(resultLabel, alertState);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum PerformanceArea {
        REQUEST_BY_STATUS("Database Access (Request By Status)", "request.by.status.warning.threshold", 3000, "request.by.status.critical.threshold", 5000){

            @Override
            void execute(OBDPPerformanceRunnable runnable, Cluster cluster) throws Exception {
                runnable.m_actionManager.getRequestsByStatus(RequestStatus.IN_PROGRESS, 20, false);
            }
        }
        ,
        HRC_SUMMARY_STATUS("Database Access (Task Status Aggregation)", "task.status.aggregation.warning.threshold", 3000, "task.status.aggregation.critical.threshold", 5000){

            @Override
            void execute(OBDPPerformanceRunnable runnable, Cluster cluster) throws Exception {
                List<Long> requestIds = runnable.m_requestDAO.findAllRequestIds(20, false);
                for (long requestId : requestIds) {
                    runnable.m_hostRoleCommandDAO.findAggregateCounts(requestId);
                }
            }
        }
        ,
        REST_API_GET_CLUSTER("REST API (Cluster)", "rest.api.cluster.warning.threshold", 5000, "rest.api.cluster.critical.threshold", 7000){

            @Override
            void execute(OBDPPerformanceRunnable runnable, Cluster cluster) throws Exception {
                InternalAuthenticationToken authenticationToken = new InternalAuthenticationToken("admin");
                authenticationToken.setAuthenticated(true);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
                HashMap<Resource.Type, String> mapIds = new HashMap<Resource.Type, String>();
                mapIds.put(Resource.Type.Cluster, cluster.getClusterName());
                ClusterController clusterController = ClusterControllerHelper.getClusterController();
                QueryImpl query = new QueryImpl(mapIds, new ClusterResourceDefinition(), clusterController);
                query.setRenderer(new MinimalRenderer());
                query.addProperty("Clusters/desired_configs", null);
                query.addProperty("Clusters/credential_store_properties", null);
                query.addProperty("Clusters/desired_service_config_versions", null);
                query.addProperty("Clusters/health_report", null);
                query.addProperty("Clusters/total_hosts", null);
                query.addProperty("alerts_summary", null);
                query.addProperty("alerts_summary_hosts", null);
                query.execute();
            }
        };

        private final String m_label;
        private final String m_warningParameter;
        private final int m_defaultWarningThreshold;
        private final String m_criticalParameter;
        private final int m_defaultCriticalThreshold;

        private PerformanceArea(String label, String warningParameter, int defaultWarningThreshold, String criticalParameter, int defaultCriticalThreshold) {
            this.m_label = label;
            this.m_warningParameter = warningParameter;
            this.m_defaultWarningThreshold = defaultWarningThreshold;
            this.m_criticalParameter = criticalParameter;
            this.m_defaultCriticalThreshold = defaultCriticalThreshold;
        }

        abstract void execute(OBDPPerformanceRunnable var1, Cluster var2) throws Exception;
    }

    private static final class PerformanceResult {
        private final String m_result;
        private final AlertState m_alertState;

        private PerformanceResult(String result, AlertState alertState) {
            this.m_result = result;
            this.m_alertState = alertState;
        }

        public String getResult() {
            return this.m_result;
        }

        public AlertState getAlertState() {
            return this.m_alertState;
        }
    }
}

