/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.alerts;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.alerts.AlertRunnable;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.jmx.JMXMetricHolder;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import id.onyx.obdp.server.state.alert.AlertDefinitionFactory;
import id.onyx.obdp.server.state.alert.MetricSource;
import id.onyx.obdp.server.state.alert.ServerSource;
import id.onyx.obdp.server.state.services.MetricsRetrievalService;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxServerSideAlert
extends AlertRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(JmxServerSideAlert.class);
    @Inject
    private AlertDefinitionFactory definitionFactory;
    @Inject
    private MetricsRetrievalService metricsRetrievalService;
    @Inject
    private ConfigHelper configHelper;

    public JmxServerSideAlert(String definitionName) {
        super(definitionName);
    }

    @Override
    List<Alert> execute(Cluster cluster, AlertDefinitionEntity entity) throws OBDPException {
        AlertDefinition alertDef = this.definitionFactory.coerce(entity);
        ServerSource serverSource = (ServerSource)alertDef.getSource();
        return this.buildAlert(this.jmxMetric(serverSource, cluster), serverSource.getJmxInfo(), alertDef).map(alert -> Collections.singletonList(alert)).orElse(Collections.emptyList());
    }

    public Optional<Alert> buildAlert(Optional<JMXMetricHolder> metricHolder, MetricSource.JmxInfo jmxInfo, AlertDefinition alertDef) {
        return metricHolder.flatMap(metric -> this.buildAlert((JMXMetricHolder)metric, jmxInfo, alertDef));
    }

    private Optional<Alert> buildAlert(JMXMetricHolder metricHolder, MetricSource.JmxInfo jmxInfo, AlertDefinition alertDef) {
        List<Object> allMetrics = metricHolder.findAll(jmxInfo.getPropertyList());
        return jmxInfo.eval(metricHolder).map(val -> alertDef.buildAlert(val.doubleValue(), allMetrics));
    }

    private Optional<JMXMetricHolder> jmxMetric(ServerSource serverSource, Cluster cluster) throws OBDPException {
        URI jmxUri = this.jmxUrl(cluster, serverSource);
        URLStreamProvider streamProvider = new URLStreamProvider(serverSource.getUri().getConnectionTimeoutMsec(), serverSource.getUri().getReadTimeoutMsec(), ComponentSSLConfiguration.instance());
        this.metricsRetrievalService.submitRequest(MetricsRetrievalService.MetricSourceType.JMX, streamProvider, jmxUri.toString());
        return Optional.ofNullable(this.metricsRetrievalService.getCachedJMXMetric(jmxUri.toString()));
    }

    private URI jmxUrl(Cluster cluster, ServerSource serverSource) throws OBDPException {
        return serverSource.getUri().resolve(this.config(cluster)).resolve(serverSource.getJmxInfo().getUrlSuffix());
    }

    private Map<String, Map<String, String>> config(Cluster cluster) throws OBDPException {
        return this.configHelper.getEffectiveConfigProperties(cluster, this.configHelper.getEffectiveDesiredTags(cluster, null));
    }
}

