/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.alerts;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.alerts.AlertRunnable;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class ComponentVersionAlertRunnable
extends AlertRunnable {
    private static final String ALL_COMPONENTS_CORRECT_MSG = "All components are reporting their expected versions.";
    private static final String UPGRADE_IN_PROGRESS_MSG = "This alert will be suspended while the {0} is in progress.";
    private static final String UNKNOWN_COMPONENT_MSG_TEMPLATE = "Unable to retrieve component information for {0}/{1}";
    private static final String MISMATCHED_VERSIONS_MSG = "The following components are reporting unexpected versions: ";
    @Inject
    private OBDPMetaInfo m_metaInfo;

    public ComponentVersionAlertRunnable(String definitionName) {
        super(definitionName);
    }

    @Override
    List<Alert> execute(Cluster cluster, AlertDefinitionEntity myDefinition) throws OBDPException {
        UpgradeEntity upgrade = cluster.getUpgradeInProgress();
        if (null != upgrade) {
            Direction direction = upgrade.getDirection();
            String message = MessageFormat.format(UPGRADE_IN_PROGRESS_MSG, direction.getText(false));
            return Collections.singletonList(this.buildAlert(cluster, myDefinition, AlertState.SKIPPED, message));
        }
        TreeMap<Host, HashSet<ServiceComponentHost>> versionMismatches = new TreeMap<Host, HashSet<ServiceComponentHost>>();
        Collection<Host> hosts = cluster.getHosts();
        for (Host host : hosts) {
            List<ServiceComponentHost> hostComponents = cluster.getServiceComponentHosts(host.getHostName());
            for (ServiceComponentHost hostComponent : hostComponents) {
                String version;
                ComponentInfo componentInfo;
                Service service = cluster.getService(hostComponent.getServiceName());
                ServiceComponent serviceComponent = service.getServiceComponent(hostComponent.getServiceComponentName());
                RepositoryVersionEntity desiredRepositoryVersion = service.getDesiredRepositoryVersion();
                StackId desiredStackId = serviceComponent.getDesiredStackId();
                String desiredVersion = desiredRepositoryVersion.getVersion();
                try {
                    componentInfo = this.m_metaInfo.getComponent(desiredStackId.getStackName(), desiredStackId.getStackVersion(), hostComponent.getServiceName(), hostComponent.getServiceComponentName());
                }
                catch (OBDPException ambariException) {
                    String message = MessageFormat.format(UNKNOWN_COMPONENT_MSG_TEMPLATE, hostComponent.getServiceName(), hostComponent.getServiceComponentName());
                    return Collections.singletonList(this.buildAlert(cluster, myDefinition, AlertState.UNKNOWN, message));
                }
                if (!componentInfo.isVersionAdvertised() || StringUtils.equals((String)(version = hostComponent.getVersion()), (String)desiredVersion)) continue;
                HashSet<ServiceComponentHost> mismatchedComponents = (HashSet<ServiceComponentHost>)versionMismatches.get(host);
                if (null == mismatchedComponents) {
                    mismatchedComponents = new HashSet<ServiceComponentHost>();
                    versionMismatches.put(host, mismatchedComponents);
                }
                mismatchedComponents.add(hostComponent);
            }
        }
        AlertState alertState = AlertState.OK;
        String alertText = ALL_COMPONENTS_CORRECT_MSG;
        if (!versionMismatches.isEmpty()) {
            StringBuilder buffer = new StringBuilder(MISMATCHED_VERSIONS_MSG);
            buffer.append(System.lineSeparator());
            for (Host host : versionMismatches.keySet()) {
                buffer.append("  ").append(host.getHostName());
                buffer.append(System.lineSeparator());
                for (ServiceComponentHost hostComponent : (Set)versionMismatches.get(host)) {
                    buffer.append("    ").append(hostComponent.getServiceComponentName()).append(": ").append(hostComponent.getVersion()).append(System.lineSeparator());
                }
            }
            alertText = buffer.toString();
            alertState = AlertState.WARNING;
        }
        return Collections.singletonList(this.buildAlert(cluster, myDefinition, alertState, alertText));
    }
}

