/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.alerts;

import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.events.AlertReceivedEvent;
import id.onyx.obdp.server.events.publishers.AlertEventPublisher;
import id.onyx.obdp.server.orm.dao.AlertDefinitionDAO;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.alert.AlertHelper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlertRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AlertRunnable.class);
    protected final String m_definitionName;
    @Inject
    private Provider<Clusters> m_clustersProvider;
    @Inject
    private AlertDefinitionDAO m_dao;
    @Inject
    private AlertEventPublisher m_alertEventPublisher;
    @Inject
    protected AlertHelper alertHelper;

    public AlertRunnable(String definitionName) {
        this.m_definitionName = definitionName;
    }

    abstract List<Alert> execute(Cluster var1, AlertDefinitionEntity var2) throws OBDPException;

    @Override
    public final void run() {
        try {
            Map<String, Cluster> clusterMap = ((Clusters)this.m_clustersProvider.get()).getClusters();
            for (Cluster cluster : clusterMap.values()) {
                AlertDefinitionEntity definition = this.m_dao.findByName(cluster.getClusterId(), this.m_definitionName);
                if (null == definition || !definition.getEnabled()) continue;
                List<Alert> alerts = this.execute(cluster, definition);
                for (Alert alert : alerts) {
                    AlertReceivedEvent event = new AlertReceivedEvent(cluster.getClusterId(), alert);
                    this.m_alertEventPublisher.publish(event);
                }
            }
        }
        catch (Exception exception) {
            LOG.error("Unable to run the {} alert", (Object)this.m_definitionName, (Object)exception);
        }
    }

    protected Alert buildAlert(Cluster cluster, AlertDefinitionEntity myDefinition, AlertState alertState, String message) {
        Alert alert = new Alert(myDefinition.getDefinitionName(), null, myDefinition.getServiceName(), myDefinition.getComponentName(), null, alertState);
        alert.setLabel(myDefinition.getLabel());
        alert.setText(message);
        alert.setTimestamp(System.currentTimeMillis());
        alert.setClusterId(cluster.getClusterId());
        return alert;
    }
}

