/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.alerts;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.alerts.AlertRunnable;
import id.onyx.obdp.server.orm.entities.AlertDefinitionEntity;
import id.onyx.obdp.server.state.Alert;
import id.onyx.obdp.server.state.AlertState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.HostState;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AgentHeartbeatAlertRunnable
extends AlertRunnable {
    private static final String INIT_MSG = "{0} is initializing";
    private static final String HEALTHY_MSG = "{0} is healthy";
    private static final String STATUS_UPDATE_MSG = "{0} is waiting for status updates";
    private static final String HEARTBEAT_LOST_MSG = "{0} is not sending heartbeats";
    private static final String UNHEALTHY_MSG = "{0} is not healthy";
    private static final String UNKNOWN_MSG = "{0} has an unknown state of {1}";

    public AgentHeartbeatAlertRunnable(String definitionName) {
        super(definitionName);
    }

    @Override
    List<Alert> execute(Cluster cluster, AlertDefinitionEntity definition) throws OBDPException {
        long alertTimestamp = System.currentTimeMillis();
        Collection<Host> hosts = cluster.getHosts();
        ArrayList<Alert> alerts = new ArrayList<Alert>(hosts.size());
        for (Host host : hosts) {
            String hostName = host.getHostName();
            AlertState alertState = AlertState.OK;
            HostState hostState = host.getState();
            String alertText = switch (hostState) {
                case HostState.INIT -> MessageFormat.format(INIT_MSG, hostName);
                case HostState.HEALTHY -> MessageFormat.format(HEALTHY_MSG, hostName);
                case HostState.WAITING_FOR_HOST_STATUS_UPDATES -> MessageFormat.format(STATUS_UPDATE_MSG, hostName);
                case HostState.HEARTBEAT_LOST -> {
                    alertState = AlertState.CRITICAL;
                    yield MessageFormat.format(HEARTBEAT_LOST_MSG, hostName);
                }
                case HostState.UNHEALTHY -> {
                    alertState = AlertState.CRITICAL;
                    yield MessageFormat.format(UNHEALTHY_MSG, hostName);
                }
                default -> {
                    alertState = AlertState.UNKNOWN;
                    yield MessageFormat.format(UNKNOWN_MSG, new Object[]{hostName, hostState});
                }
            };
            Alert alert = new Alert(definition.getDefinitionName(), null, definition.getServiceName(), definition.getComponentName(), hostName, alertState);
            alert.setLabel(definition.getLabel());
            alert.setText(alertText);
            alert.setTimestamp(alertTimestamp);
            alert.setClusterId(cluster.getClusterId());
            alerts.add(alert);
        }
        return alerts;
    }
}

