/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.commons.lang.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TopologyHost {
    private Long hostId;
    private String hostName;
    private String rackName;
    private String ipv4;

    public TopologyHost(Long hostId, String hostName) {
        this.hostId = hostId;
        this.hostName = hostName;
    }

    public TopologyHost(Long hostId, String hostName, String rackName, String ipv4) {
        this.hostId = hostId;
        this.hostName = hostName;
        this.rackName = rackName;
        this.ipv4 = ipv4;
    }

    public boolean updateHost(TopologyHost hostToUpdate) {
        boolean changed = false;
        if (hostToUpdate.getHostId().equals(this.getHostId())) {
            if (StringUtils.isNotEmpty((String)hostToUpdate.getHostName()) && !hostToUpdate.getHostName().equals(this.getHostName())) {
                this.setHostName(hostToUpdate.getHostName());
                changed = true;
            }
            if (StringUtils.isNotEmpty((String)hostToUpdate.getRackName()) && !hostToUpdate.getRackName().equals(this.getRackName())) {
                this.setRackName(hostToUpdate.getRackName());
                changed = true;
            }
            if (StringUtils.isNotEmpty((String)hostToUpdate.getIpv4()) && !hostToUpdate.getIpv4().equals(this.getIpv4())) {
                this.setIpv4(hostToUpdate.getIpv4());
                changed = true;
            }
        }
        return changed;
    }

    public TopologyHost deepCopy() {
        return new TopologyHost(this.getHostId(), this.getHostName(), this.getRackName(), this.getIpv4());
    }

    public Long getHostId() {
        return this.hostId;
    }

    public void setHostId(Long hostId) {
        this.hostId = hostId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getRackName() {
        return this.rackName;
    }

    public void setRackName(String rackName) {
        this.rackName = rackName;
    }

    public String getIpv4() {
        return this.ipv4;
    }

    public void setIpv4(String ipv4) {
        this.ipv4 = ipv4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyHost that = (TopologyHost)o;
        return this.hostId.equals(that.hostId);
    }

    public int hashCode() {
        return this.hostId.hashCode();
    }
}

