/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import id.onyx.obdp.server.state.State;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class TopologyComponent {
    private String componentName;
    private String serviceName;
    private String displayName;
    private String version;
    private Set<Long> hostIds = new HashSet<Long>();
    private Set<String> hostNames = new HashSet<String>();
    private Set<String> publicHostNames = new HashSet<String>();
    private TreeMap<String, String> componentLevelParams = new TreeMap();
    private TreeMap<String, String> commandParams = new TreeMap();
    private State lastComponentState;

    private TopologyComponent() {
    }

    public static Builder newBuilder() {
        return new TopologyComponent().new Builder();
    }

    public boolean updateComponent(TopologyComponent componentToUpdate) {
        boolean changed = false;
        if (componentToUpdate.getComponentName().equals(this.getComponentName())) {
            if (StringUtils.isNotEmpty((String)componentToUpdate.getVersion()) && !componentToUpdate.getVersion().equals(this.getVersion())) {
                this.setVersion(componentToUpdate.getVersion());
                changed = true;
            }
            if (CollectionUtils.isNotEmpty(componentToUpdate.getHostIds())) {
                if (this.hostIds == null) {
                    this.hostIds = new HashSet<Long>();
                }
                changed |= this.hostIds.addAll(componentToUpdate.getHostIds());
            }
            if (CollectionUtils.isNotEmpty(componentToUpdate.getHostNames())) {
                if (this.hostNames == null) {
                    this.hostNames = new HashSet<String>();
                }
                changed |= this.hostNames.addAll(componentToUpdate.getHostNames());
            }
            if (CollectionUtils.isNotEmpty(componentToUpdate.getPublicHostNames())) {
                if (this.publicHostNames == null) {
                    this.publicHostNames = new HashSet<String>();
                }
                changed |= this.publicHostNames.addAll(componentToUpdate.getPublicHostNames());
            }
            changed |= this.mergeParams(this.componentLevelParams, componentToUpdate.getComponentLevelParams());
            changed |= this.mergeParams(this.commandParams, componentToUpdate.getCommandParams());
        }
        return changed;
    }

    private boolean mergeParams(TreeMap<String, String> currentParams, TreeMap<String, String> updateParams) {
        boolean changed = false;
        if (MapUtils.isNotEmpty(updateParams)) {
            for (Map.Entry<String, String> updateParam : updateParams.entrySet()) {
                String updateParamName = updateParam.getKey();
                String updateParamValue = updateParam.getValue();
                if (currentParams.containsKey(updateParamName) && StringUtils.equals((String)currentParams.get(updateParamName), (String)updateParamValue)) continue;
                currentParams.put(updateParamName, updateParamValue);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeComponent(TopologyComponent componentToRemove) {
        boolean changed = false;
        if (componentToRemove.getComponentName().equals(this.getComponentName())) {
            if (CollectionUtils.isNotEmpty(componentToRemove.getHostIds()) && this.hostIds != null) {
                this.hostIds.removeAll(componentToRemove.getHostIds());
                changed = true;
            }
            if (CollectionUtils.isNotEmpty(componentToRemove.getHostNames()) && this.hostNames != null) {
                this.hostNames.removeAll(componentToRemove.getHostNames());
                changed = true;
            }
            if (CollectionUtils.isNotEmpty(componentToRemove.getPublicHostNames()) && this.publicHostNames != null) {
                this.publicHostNames.removeAll(componentToRemove.getPublicHostNames());
                changed = true;
            }
        }
        return changed;
    }

    public TopologyComponent deepCopy() {
        return TopologyComponent.newBuilder().setComponentName(this.getComponentName()).setDisplayName(this.getDisplayName()).setServiceName(this.getServiceName()).setComponentLevelParams(this.getComponentLevelParams() == null ? null : new TreeMap<String, String>((SortedMap<String, String>)this.getComponentLevelParams())).setHostIdentifiers(this.getHostIds() == null ? null : new HashSet<Long>(this.getHostIds()), (Set<String>)(this.getHostNames() == null ? null : new HashSet<String>(this.getHostNames()))).setPublicHostNames((Set<String>)(this.getPublicHostNames() == null ? null : new HashSet<String>(this.getPublicHostNames()))).setCommandParams(this.getCommandParams() == null ? null : new TreeMap<String, String>((SortedMap<String, String>)this.getCommandParams())).build();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<Long> getHostIds() {
        return this.hostIds;
    }

    public void setHostIds(Set<Long> hostIds) {
        this.hostIds = hostIds;
    }

    public void addHostId(Long hostId) {
        this.hostIds.add(hostId);
    }

    public void addHostName(String hostName) {
        this.hostNames.add(hostName);
    }

    public TreeMap<String, String> getComponentLevelParams() {
        return this.componentLevelParams;
    }

    public void setComponentLevelParams(TreeMap<String, String> componentLevelParams) {
        this.componentLevelParams = componentLevelParams;
    }

    public Set<String> getHostNames() {
        return this.hostNames;
    }

    public void setHostNames(Set<String> hostNames) {
        this.hostNames = hostNames;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Set<String> getPublicHostNames() {
        return this.publicHostNames;
    }

    public void setPublicHostNames(Set<String> publicHostNames) {
        this.publicHostNames = publicHostNames;
    }

    public TreeMap<String, String> getCommandParams() {
        return this.commandParams;
    }

    public void setCommandParams(TreeMap<String, String> commandParams) {
        this.commandParams = commandParams;
    }

    public State getLastComponentState() {
        return this.lastComponentState;
    }

    public void setLastComponentState(State lastComponentState) {
        this.lastComponentState = lastComponentState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyComponent that = (TopologyComponent)o;
        if (!this.componentName.equals(that.componentName)) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        int result = this.componentName.hashCode();
        result = 31 * result + this.serviceName.hashCode();
        return result;
    }

    public class Builder {
        private Builder() {
        }

        public Builder setComponentName(String componentName) {
            TopologyComponent.this.setComponentName(componentName);
            return this;
        }

        public Builder setServiceName(String serviceName) {
            TopologyComponent.this.setServiceName(serviceName);
            return this;
        }

        public Builder setDisplayName(String displayName) {
            TopologyComponent.this.setDisplayName(displayName);
            return this;
        }

        public Builder setVersion(String version) {
            TopologyComponent.this.setVersion(version);
            return this;
        }

        public Builder setHostIdentifiers(Set<Long> hostIds, Set<String> hostNames) {
            TopologyComponent.this.setHostIds(hostIds);
            TopologyComponent.this.setHostNames(hostNames);
            return this;
        }

        public Builder setPublicHostNames(Set<String> publicHostNames) {
            TopologyComponent.this.setPublicHostNames(publicHostNames);
            return this;
        }

        public Builder setComponentLevelParams(TreeMap<String, String> componentLevelParams) {
            TopologyComponent.this.setComponentLevelParams(componentLevelParams);
            return this;
        }

        public Builder setCommandParams(TreeMap<String, String> commandParams) {
            TopologyComponent.this.setCommandParams(commandParams);
            return this;
        }

        public Builder setLastComponentState(State lastComponentState) {
            TopologyComponent.this.setLastComponentState(lastComponentState);
            return this;
        }

        public TopologyComponent build() {
            return TopologyComponent.this;
        }
    }
}

