/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.NullHostNameException;
import id.onyx.obdp.server.agent.stomp.dto.TopologyComponent;
import id.onyx.obdp.server.agent.stomp.dto.TopologyHost;
import id.onyx.obdp.server.agent.stomp.dto.TopologyUpdateHandlingReport;
import id.onyx.obdp.server.events.UpdateEventType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TopologyCluster {
    @JsonProperty(value="components")
    private Set<TopologyComponent> topologyComponents = new HashSet<TopologyComponent>();
    @JsonProperty(value="hosts")
    private Set<TopologyHost> topologyHosts = new HashSet<TopologyHost>();

    public TopologyCluster() {
    }

    public TopologyCluster(Set<TopologyComponent> topologyComponents, Set<TopologyHost> topologyHosts) {
        this.topologyComponents = topologyComponents;
        this.topologyHosts = topologyHosts;
    }

    public void update(Set<TopologyComponent> componentsToUpdate, Set<TopologyHost> hostsToUpdate, UpdateEventType eventType, TopologyUpdateHandlingReport report) throws NullHostNameException {
        Iterator<Object> iter;
        boolean isPresent;
        for (TopologyComponent componentToUpdate : componentsToUpdate) {
            isPresent = false;
            iter = this.getTopologyComponents().iterator();
            while (iter.hasNext() && !isPresent) {
                TopologyComponent existsComponent = iter.next();
                if (!existsComponent.equals(componentToUpdate)) continue;
                if (eventType.equals((Object)UpdateEventType.DELETE)) {
                    if (SetUtils.isEqualSet(existsComponent.getHostIds(), componentToUpdate.getHostIds())) {
                        iter.remove();
                        report.mappingWasChanged();
                        report.addHostsNames(componentToUpdate.getHostNames());
                    } else if (existsComponent.removeComponent(componentToUpdate)) {
                        report.mappingWasChanged();
                        report.addHostsNames(componentToUpdate.getHostNames());
                    }
                } else {
                    HashSet<String> preExistNames = new HashSet<String>(existsComponent.getHostNames());
                    if (existsComponent.updateComponent(componentToUpdate)) {
                        report.mappingWasChanged();
                        HashSet<String> namesToUpdate = new HashSet<String>(componentToUpdate.getHostNames());
                        namesToUpdate.removeAll(preExistNames);
                        report.addHostsNames(namesToUpdate);
                    }
                }
                isPresent = true;
            }
            if (isPresent || !eventType.equals((Object)UpdateEventType.UPDATE)) continue;
            this.getTopologyComponents().add(componentToUpdate);
            report.mappingWasChanged();
            report.addHostsNames(componentToUpdate.getHostNames());
        }
        for (TopologyHost hostToUpdate : hostsToUpdate) {
            isPresent = false;
            iter = this.getTopologyHosts().iterator();
            while (iter.hasNext() && !isPresent) {
                TopologyHost existsHost = (TopologyHost)iter.next();
                if (!existsHost.equals(hostToUpdate)) continue;
                if (eventType.equals((Object)UpdateEventType.DELETE)) {
                    iter.remove();
                    report.mappingWasChanged();
                    report.addHostName(existsHost.getHostName());
                } else if (existsHost.updateHost(hostToUpdate)) {
                    report.mappingWasChanged();
                    report.addHostName(existsHost.getHostName());
                    report.addHostName(hostToUpdate.getHostName());
                }
                isPresent = true;
            }
            if (isPresent || !eventType.equals((Object)UpdateEventType.UPDATE)) continue;
            this.getTopologyHosts().add(hostToUpdate);
            report.mappingWasChanged();
            report.addHostName(hostToUpdate.getHostName());
        }
    }

    public Set<TopologyComponent> getTopologyComponents() {
        return this.topologyComponents;
    }

    public void setTopologyComponents(Set<TopologyComponent> topologyComponents) {
        this.topologyComponents = topologyComponents;
    }

    public Set<TopologyHost> getTopologyHosts() {
        return this.topologyHosts;
    }

    public Set<TopologyHost> deepCopyTopologyHosts() {
        return this.topologyHosts;
    }

    public TopologyCluster deepCopyCluster() {
        HashSet<TopologyComponent> copiedComponents = null;
        if (CollectionUtils.isNotEmpty(this.topologyComponents)) {
            copiedComponents = new HashSet<TopologyComponent>();
            for (TopologyComponent topologyComponent : this.topologyComponents) {
                copiedComponents.add(topologyComponent.deepCopy());
            }
        }
        HashSet<TopologyHost> copiedHosts = null;
        if (CollectionUtils.isNotEmpty(this.topologyHosts)) {
            copiedHosts = new HashSet<TopologyHost>();
            for (TopologyHost topologyHost : this.topologyHosts) {
                copiedHosts.add(topologyHost.deepCopy());
            }
        }
        return new TopologyCluster(copiedComponents, copiedHosts);
    }

    public void setTopologyHosts(Set<TopologyHost> topologyHosts) {
        this.topologyHosts = topologyHosts;
    }

    public void addTopologyHost(TopologyHost topologyHost) {
        this.topologyHosts.add(topologyHost);
    }

    public void addTopologyComponent(TopologyComponent topologyComponent) {
        this.topologyComponents.add(topologyComponent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyCluster that = (TopologyCluster)o;
        if (this.topologyComponents != null ? !this.topologyComponents.equals(that.topologyComponents) : that.topologyComponents != null) {
            return false;
        }
        return this.topologyHosts != null ? this.topologyHosts.equals(that.topologyHosts) : that.topologyHosts == null;
    }

    public int hashCode() {
        int result = this.topologyComponents != null ? this.topologyComponents.hashCode() : 0;
        result = 31 * result + (this.topologyHosts != null ? this.topologyHosts.hashCode() : 0);
        return result;
    }
}

