/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.agent.stomp.dto.MetadataServiceInfo;
import id.onyx.obdp.server.state.SecurityType;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class MetadataCluster {
    private final Lock lock = new ReentrantLock();
    @JsonProperty(value="status_commands_to_run")
    private final Set<String> statusCommandsToRun = new HashSet<String>();
    private final boolean fullServiceLevelMetadata;
    private SortedMap<String, MetadataServiceInfo> serviceLevelParams;
    private SortedMap<String, String> clusterLevelParams;
    private SortedMap<String, SortedMap<String, String>> agentConfigs;

    public MetadataCluster(SecurityType securityType, SortedMap<String, MetadataServiceInfo> serviceLevelParams, boolean fullServiceLevelMetadata, SortedMap<String, String> clusterLevelParams, SortedMap<String, SortedMap<String, String>> agentConfigs) {
        if (securityType != null) {
            this.statusCommandsToRun.add("STATUS");
        }
        this.fullServiceLevelMetadata = fullServiceLevelMetadata;
        this.serviceLevelParams = serviceLevelParams;
        this.clusterLevelParams = clusterLevelParams;
        this.agentConfigs = agentConfigs;
    }

    public static MetadataCluster emptyMetadataCluster() {
        return new MetadataCluster(null, null, false, null, null);
    }

    public static MetadataCluster serviceLevelParamsMetadataCluster(SecurityType securityType, SortedMap<String, MetadataServiceInfo> serviceLevelParams, boolean fullServiceLevelMetadata) {
        return new MetadataCluster(securityType, serviceLevelParams, fullServiceLevelMetadata, null, null);
    }

    public static MetadataCluster clusterLevelParamsMetadataCluster(SecurityType securityType, SortedMap<String, String> clusterLevelParams) {
        return new MetadataCluster(securityType, null, false, clusterLevelParams, null);
    }

    public Set<String> getStatusCommandsToRun() {
        return this.statusCommandsToRun;
    }

    public SortedMap<String, MetadataServiceInfo> getServiceLevelParams() {
        return this.serviceLevelParams;
    }

    public SortedMap<String, String> getClusterLevelParams() {
        return this.clusterLevelParams;
    }

    public SortedMap<String, SortedMap<String, String>> getAgentConfigs() {
        return this.agentConfigs;
    }

    public boolean isFullServiceLevelMetadata() {
        return this.fullServiceLevelMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateServiceLevelParams(SortedMap<String, MetadataServiceInfo> update, boolean fullMetadataInUpdatedMap) {
        if (update != null) {
            try {
                this.lock.lock();
                if (this.serviceLevelParams == null) {
                    this.serviceLevelParams = new TreeMap<String, MetadataServiceInfo>();
                }
                boolean bl = this.updateMapIfNeeded(this.serviceLevelParams, update, fullMetadataInUpdatedMap);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    public boolean updateClusterLevelParams(SortedMap<String, String> update) {
        if (update != null) {
            try {
                this.lock.lock();
                if (this.clusterLevelParams == null) {
                    this.clusterLevelParams = new TreeMap<String, String>();
                }
                boolean bl = this.updateMapIfNeeded(this.clusterLevelParams, update, true);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    private <T> boolean updateMapIfNeeded(Map<String, T> currentMap, Map<String, T> updatedMap, boolean fullMetadataInUpdatedMap) {
        boolean changed = false;
        if (fullMetadataInUpdatedMap) {
            boolean bl = changed = !Objects.equals(currentMap, updatedMap);
            if (changed) {
                currentMap.clear();
                currentMap.putAll(updatedMap);
            }
        } else {
            for (String key : updatedMap.keySet()) {
                if (currentMap.containsKey(key) && currentMap.get(key).equals(updatedMap.get(key))) continue;
                currentMap.put(key, updatedMap.get(key));
                changed = true;
            }
        }
        return changed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataCluster that = (MetadataCluster)o;
        return Objects.equals(this.statusCommandsToRun, that.statusCommandsToRun) && Objects.equals(this.serviceLevelParams, that.serviceLevelParams) && Objects.equals(this.clusterLevelParams, that.clusterLevelParams);
    }

    public int hashCode() {
        return Objects.hash(this.statusCommandsToRun, this.serviceLevelParams, this.clusterLevelParams);
    }
}

