/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.orm.entities.AlertGroupEntity;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AlertGroupUpdate {
    @JsonProperty(value="cluster_id")
    private Long clusterId;
    @JsonProperty(value="default")
    private Boolean defaultGroup;
    @JsonProperty(value="definitions")
    private List<Long> definitions;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="service_name")
    private String serviceName;
    @JsonProperty(value="targets")
    private List<Long> targets;

    public AlertGroupUpdate(AlertGroupEntity alertGroupEntity) {
        this.clusterId = alertGroupEntity.getClusterId();
        this.defaultGroup = alertGroupEntity.isDefault();
        this.definitions = alertGroupEntity.getAlertDefinitions().stream().map(al -> al.getDefinitionId()).collect(Collectors.toList());
        this.id = alertGroupEntity.getGroupId();
        this.name = alertGroupEntity.getGroupName();
        this.serviceName = alertGroupEntity.getServiceName();
        this.targets = alertGroupEntity.getAlertTargets().stream().map(at -> at.getTargetId()).collect(Collectors.toList());
    }

    public AlertGroupUpdate(Long id) {
        this.id = id;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public Boolean getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(Boolean defaultGroup) {
        this.defaultGroup = defaultGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Long> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(List<Long> definitions) {
        this.definitions = definitions;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<Long> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Long> targets) {
        this.targets = targets;
    }
}

