/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import id.onyx.obdp.server.events.AlertDefinitionEventType;
import id.onyx.obdp.server.state.alert.AlertDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AlertCluster {
    private static final Logger LOG = LoggerFactory.getLogger(AlertCluster.class);
    private final Map<Long, AlertDefinition> alertDefinitions;
    private final String hostName;
    private Integer staleIntervalMultiplier;

    public AlertCluster(AlertDefinition alertDefinition, String hostName, Integer staleIntervalMultiplier) {
        this(Collections.singletonMap(alertDefinition.getDefinitionId(), alertDefinition), hostName, staleIntervalMultiplier);
    }

    public AlertCluster(Map<Long, AlertDefinition> alertDefinitions, String hostName, Integer staleIntervalMultiplier) {
        this.alertDefinitions = new HashMap<Long, AlertDefinition>(alertDefinitions);
        this.hostName = hostName;
        this.staleIntervalMultiplier = staleIntervalMultiplier;
    }

    public AlertCluster(AlertDefinition alertDefinition, String hostName) {
        this(Collections.singletonMap(alertDefinition.getDefinitionId(), alertDefinition), hostName, null);
    }

    public AlertCluster(Map<Long, AlertDefinition> alertDefinitions, String hostName) {
        this.alertDefinitions = new HashMap<Long, AlertDefinition>(alertDefinitions);
        this.hostName = hostName;
        this.staleIntervalMultiplier = null;
    }

    private AlertCluster() {
        this.alertDefinitions = null;
        this.hostName = null;
    }

    @JsonProperty(value="staleIntervalMultiplier")
    public Integer getStaleIntervalMultiplier() {
        return this.staleIntervalMultiplier;
    }

    @JsonProperty(value="alertDefinitions")
    public Collection<AlertDefinition> getAlertDefinitions() {
        return this.alertDefinitions == null ? Collections.emptyList() : this.alertDefinitions.values();
    }

    @JsonProperty(value="hostName")
    public String getHostName() {
        return this.hostName;
    }

    public AlertCluster handleUpdate(AlertDefinitionEventType eventType, AlertCluster update) {
        boolean changed = false;
        AlertCluster mergedCluster = null;
        HashMap<Long, AlertDefinition> mergedDefinitions = new HashMap<Long, AlertDefinition>();
        Integer mergedStaleIntervalMultiplier = null;
        switch (eventType) {
            case CREATE: 
            case UPDATE: {
                for (Map.Entry<Long, AlertDefinition> alertDefinitionEntry : this.alertDefinitions.entrySet()) {
                    Long definitionId = alertDefinitionEntry.getKey();
                    if (!update.alertDefinitions.containsKey(definitionId)) {
                        mergedDefinitions.put(definitionId, alertDefinitionEntry.getValue());
                        continue;
                    }
                    AlertDefinition newDefinition = update.alertDefinitions.get(definitionId);
                    AlertDefinition oldDefinition = alertDefinitionEntry.getValue();
                    if (!oldDefinition.deeplyEquals(newDefinition)) {
                        changed = true;
                    }
                    mergedDefinitions.put(definitionId, newDefinition);
                }
                if (this.addNewAlertDefinitions(update, mergedDefinitions)) {
                    changed = true;
                }
                if (update.getStaleIntervalMultiplier() != null && !update.getStaleIntervalMultiplier().equals(this.staleIntervalMultiplier)) {
                    mergedStaleIntervalMultiplier = update.getStaleIntervalMultiplier();
                    changed = true;
                } else {
                    mergedStaleIntervalMultiplier = this.staleIntervalMultiplier;
                }
                LOG.debug("Handled {} of {} alerts, changed = {}", new Object[]{eventType, update.alertDefinitions.size(), changed});
                break;
            }
            case DELETE: {
                for (Map.Entry<Long, AlertDefinition> alertDefinitionEntry : this.alertDefinitions.entrySet()) {
                    Long definitionId = alertDefinitionEntry.getKey();
                    if (!update.alertDefinitions.containsKey(definitionId)) {
                        mergedDefinitions.put(definitionId, alertDefinitionEntry.getValue());
                        continue;
                    }
                    changed = true;
                }
                mergedStaleIntervalMultiplier = this.staleIntervalMultiplier;
                LOG.debug("Handled {} of {} alerts", (Object)eventType, (Object)update.alertDefinitions.size());
                break;
            }
            default: {
                LOG.warn("Unhandled event type {}", (Object)eventType);
            }
        }
        if (changed) {
            mergedCluster = new AlertCluster(mergedDefinitions, this.hostName, mergedStaleIntervalMultiplier);
        }
        return mergedCluster;
    }

    private boolean addNewAlertDefinitions(AlertCluster update, Map<Long, AlertDefinition> mergedDefinitions) {
        boolean hasNew = false;
        for (Map.Entry<Long, AlertDefinition> each : update.alertDefinitions.entrySet()) {
            if (mergedDefinitions.containsKey(each.getKey())) continue;
            mergedDefinitions.put(each.getKey(), each.getValue());
            hasNew = true;
        }
        return hasNew;
    }

    public static AlertCluster emptyAlertCluster() {
        return new AlertCluster();
    }
}

