/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.AgentClusterDataHolder;
import id.onyx.obdp.server.agent.stomp.dto.TopologyCluster;
import id.onyx.obdp.server.agent.stomp.dto.TopologyComponent;
import id.onyx.obdp.server.agent.stomp.dto.TopologyHost;
import id.onyx.obdp.server.agent.stomp.dto.TopologyUpdateHandlingReport;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.events.ClusterComponentsRepoChangedEvent;
import id.onyx.obdp.server.events.TopologyAgentUpdateEvent;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TopologyHolder
extends AgentClusterDataHolder<TopologyUpdateEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyHolder.class);
    @Inject
    private OBDPManagementControllerImpl ambariManagementController;
    @Inject
    private Clusters clusters;
    @Inject
    private StackAdvisorHelper stackAdvisorHelper;

    @Inject
    public TopologyHolder(OBDPEventPublisher ambariEventPublisher) {
        ambariEventPublisher.register(this);
    }

    @Override
    public TopologyUpdateEvent getUpdateIfChanged(String agentHash) throws OBDPException {
        TopologyUpdateEvent topologyUpdateEvent = (TopologyUpdateEvent)super.getUpdateIfChanged(agentHash);
        this.prepareAgentTopology(topologyUpdateEvent);
        return topologyUpdateEvent;
    }

    @Override
    public TopologyUpdateEvent getCurrentData() throws OBDPException {
        TreeMap<String, TopologyCluster> topologyClusters = new TreeMap<String, TopologyCluster>();
        for (Cluster cl : this.clusters.getClusters().values()) {
            Collection<Host> clusterHosts = cl.getHosts();
            HashSet<TopologyComponent> topologyComponents = new HashSet<TopologyComponent>();
            HashSet<TopologyHost> topologyHosts = new HashSet<TopologyHost>();
            for (Host host : clusterHosts) {
                topologyHosts.add(new TopologyHost(host.getHostId(), host.getHostName(), host.getRackInfo(), host.getIPv4()));
            }
            for (Service service : cl.getServices().values()) {
                for (ServiceComponent component : service.getServiceComponents().values()) {
                    Map<String, ServiceComponentHost> componentsMap = component.getServiceComponentHosts();
                    if (componentsMap.isEmpty()) continue;
                    ServiceComponentHost sch = componentsMap.entrySet().iterator().next().getValue();
                    Set<String> hostNames = cl.getHosts(sch.getServiceName(), sch.getServiceComponentName());
                    Set<Long> hostOrderIds = clusterHosts.stream().filter(h -> hostNames.contains(h.getHostName())).map(Host::getHostId).collect(Collectors.toSet());
                    Set<String> hostOrderNames = clusterHosts.stream().filter(h -> hostNames.contains(h.getHostName())).map(Host::getHostName).collect(Collectors.toSet());
                    String serviceName = sch.getServiceName();
                    String componentName = sch.getServiceComponentName();
                    TopologyComponent topologyComponent = TopologyComponent.newBuilder().setComponentName(sch.getServiceComponentName()).setServiceName(sch.getServiceName()).setHostIdentifiers(hostOrderIds, hostOrderNames).setComponentLevelParams(this.ambariManagementController.getTopologyComponentLevelParams(cl.getClusterId(), serviceName, componentName, cl.getSecurityType())).setCommandParams(this.ambariManagementController.getTopologyCommandParams(cl.getClusterId(), serviceName, componentName, sch)).build();
                    topologyComponents.add(topologyComponent);
                }
            }
            topologyClusters.put(Long.toString(cl.getClusterId()), new TopologyCluster(topologyComponents, topologyHosts));
        }
        return new TopologyUpdateEvent(topologyClusters, UpdateEventType.CREATE);
    }

    @Override
    public boolean updateData(TopologyUpdateEvent update) throws OBDPException {
        boolean changed = super.updateData(update);
        if (changed) {
            TopologyUpdateEvent copiedUpdate = update.deepCopy();
            TopologyAgentUpdateEvent topologyAgentUpdateEvent = new TopologyAgentUpdateEvent(copiedUpdate.getClusters(), copiedUpdate.getHash(), copiedUpdate.getEventType());
            this.prepareAgentTopology(topologyAgentUpdateEvent);
            LOG.debug("Publishing Topology Agent Update Event hash={}", (Object)topologyAgentUpdateEvent.getHash());
            this.STOMPUpdatePublisher.publish(topologyAgentUpdateEvent);
        }
        return changed;
    }

    @Override
    protected boolean handleUpdate(TopologyUpdateEvent update) throws OBDPException {
        TopologyUpdateHandlingReport report = new TopologyUpdateHandlingReport();
        UpdateEventType eventType = update.getEventType();
        for (Map.Entry<String, TopologyCluster> updatedCluster : update.getClusters().entrySet()) {
            String clusterId = updatedCluster.getKey();
            TopologyCluster cluster = updatedCluster.getValue();
            if (((TopologyUpdateEvent)this.getData()).getClusters().containsKey(clusterId)) {
                if (eventType.equals((Object)UpdateEventType.DELETE) && CollectionUtils.isEmpty(cluster.getTopologyComponents()) && CollectionUtils.isEmpty(cluster.getTopologyHosts())) {
                    ((TopologyUpdateEvent)this.getData()).getClusters().remove(clusterId);
                    report.mappingWasChanged();
                    continue;
                }
                ((TopologyCluster)((TopologyUpdateEvent)this.getData()).getClusters().get(clusterId)).update(((TopologyCluster)update.getClusters().get(clusterId)).getTopologyComponents(), ((TopologyCluster)update.getClusters().get(clusterId)).getTopologyHosts(), eventType, report);
                continue;
            }
            if (eventType.equals((Object)UpdateEventType.UPDATE)) {
                ((TopologyUpdateEvent)this.getData()).getClusters().put(clusterId, cluster);
                report.mappingWasChanged();
                continue;
            }
            throw new ClusterNotFoundException(Long.parseLong(clusterId));
        }
        this.stackAdvisorHelper.clearCaches(report.getUpdatedHostNames());
        return report.wasChanged();
    }

    private void prepareAgentTopology(TopologyUpdateEvent topologyUpdateEvent) {
        if (topologyUpdateEvent.getClusters() != null) {
            for (TopologyCluster topologyCluster : topologyUpdateEvent.getClusters().values()) {
                if (CollectionUtils.isNotEmpty(topologyCluster.getTopologyComponents())) {
                    for (TopologyComponent topologyComponent : topologyCluster.getTopologyComponents()) {
                        topologyComponent.setHostNames(new HashSet<String>());
                        topologyComponent.setPublicHostNames(new HashSet<String>());
                        topologyComponent.setLastComponentState(null);
                    }
                }
                if (!topologyUpdateEvent.getEventType().equals((Object)UpdateEventType.DELETE) || !CollectionUtils.isNotEmpty(topologyCluster.getTopologyHosts())) continue;
                for (TopologyHost topologyHost : topologyCluster.getTopologyHosts()) {
                    topologyHost.setHostName(null);
                }
            }
        }
    }

    @Override
    protected TopologyUpdateEvent getEmptyData() {
        return TopologyUpdateEvent.emptyUpdate();
    }

    @Subscribe
    public void onClusterComponentsRepoUpdate(ClusterComponentsRepoChangedEvent clusterComponentsRepoChangedEvent) throws OBDPException {
        Long clusterId = clusterComponentsRepoChangedEvent.getClusterId();
        TopologyCluster topologyCluster = new TopologyCluster();
        topologyCluster.setTopologyComponents(this.getTopologyComponentRepos(clusterId));
        TreeMap<String, TopologyCluster> topologyUpdates = new TreeMap<String, TopologyCluster>();
        topologyUpdates.put(Long.toString(clusterId), topologyCluster);
        TopologyUpdateEvent topologyUpdateEvent = new TopologyUpdateEvent(topologyUpdates, UpdateEventType.UPDATE);
        this.updateData(topologyUpdateEvent);
    }

    private Set<TopologyComponent> getTopologyComponentRepos(Long clusterId) throws OBDPException {
        HashSet<TopologyComponent> topologyComponents = new HashSet<TopologyComponent>();
        Cluster cl = this.clusters.getCluster(clusterId);
        for (Service service : cl.getServices().values()) {
            for (ServiceComponent component : service.getServiceComponents().values()) {
                Map<String, ServiceComponentHost> componentsMap = component.getServiceComponentHosts();
                if (componentsMap.isEmpty()) continue;
                ServiceComponentHost sch = componentsMap.entrySet().iterator().next().getValue();
                String serviceName = sch.getServiceName();
                String componentName = sch.getServiceComponentName();
                TopologyComponent topologyComponent = TopologyComponent.newBuilder().setComponentName(sch.getServiceComponentName()).setServiceName(sch.getServiceName()).setCommandParams(this.ambariManagementController.getTopologyCommandParams(cl.getClusterId(), serviceName, componentName, sch)).setComponentLevelParams(this.ambariManagementController.getTopologyComponentLevelParams(clusterId, serviceName, componentName, cl.getSecurityType())).build();
                topologyComponents.add(topologyComponent);
            }
        }
        return topologyComponents;
    }
}

