/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.stomp.AgentClusterDataHolder;
import id.onyx.obdp.server.agent.stomp.dto.MetadataCluster;
import id.onyx.obdp.server.controller.OBDPManagementControllerImpl;
import id.onyx.obdp.server.events.AmbariPropertiesChangedEvent;
import id.onyx.obdp.server.events.ClusterComponentsRepoChangedEvent;
import id.onyx.obdp.server.events.MetadataUpdateEvent;
import id.onyx.obdp.server.events.ServiceCredentialStoreUpdateEvent;
import id.onyx.obdp.server.events.ServiceInstalledEvent;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@Singleton
public class MetadataHolder
extends AgentClusterDataHolder<MetadataUpdateEvent> {
    @Inject
    private OBDPManagementControllerImpl ambariManagementController;
    @Inject
    private Provider<Clusters> m_clusters;

    @Inject
    public MetadataHolder(OBDPEventPublisher ambariEventPublisher) {
        ambariEventPublisher.register(this);
    }

    @Override
    public MetadataUpdateEvent getCurrentData() throws OBDPException {
        return this.ambariManagementController.getClustersMetadata();
    }

    public MetadataUpdateEvent getDeleteMetadata(Long clusterId) throws OBDPException {
        TreeMap<String, MetadataCluster> clusterToRemove = new TreeMap<String, MetadataCluster>();
        if (clusterId != null) {
            clusterToRemove.put(Long.toString(clusterId), MetadataCluster.emptyMetadataCluster());
        }
        MetadataUpdateEvent deleteEvent = new MetadataUpdateEvent(clusterToRemove, null, null, UpdateEventType.DELETE);
        return deleteEvent;
    }

    @Override
    protected boolean handleUpdate(MetadataUpdateEvent update) throws OBDPException {
        boolean changed = false;
        UpdateEventType eventType = update.getEventType();
        if (MapUtils.isNotEmpty(update.getMetadataClusters())) {
            for (Map.Entry<String, MetadataCluster> metadataClusterEntry : update.getMetadataClusters().entrySet()) {
                MetadataCluster updatedCluster = metadataClusterEntry.getValue();
                String clusterId = metadataClusterEntry.getKey();
                Map<String, MetadataCluster> clusters = ((MetadataUpdateEvent)this.getData()).getMetadataClusters();
                if (clusters.containsKey(clusterId)) {
                    if (eventType.equals((Object)UpdateEventType.DELETE)) {
                        ((MetadataUpdateEvent)this.getData()).getMetadataClusters().remove(clusterId);
                        changed = true;
                        continue;
                    }
                    MetadataCluster cluster = clusters.get(clusterId);
                    if (cluster.updateClusterLevelParams(updatedCluster.getClusterLevelParams())) {
                        changed = true;
                    }
                    if (cluster.updateServiceLevelParams(updatedCluster.getServiceLevelParams(), updatedCluster.isFullServiceLevelMetadata())) {
                        changed = true;
                    }
                    if (!CollectionUtils.isNotEmpty(updatedCluster.getStatusCommandsToRun()) || cluster.getStatusCommandsToRun().containsAll(updatedCluster.getStatusCommandsToRun())) continue;
                    cluster.getStatusCommandsToRun().addAll(updatedCluster.getStatusCommandsToRun());
                    changed = true;
                    continue;
                }
                if (eventType.equals((Object)UpdateEventType.UPDATE)) {
                    clusters.put(clusterId, updatedCluster);
                    changed = true;
                    continue;
                }
                throw new ClusterNotFoundException(Long.parseLong(clusterId));
            }
        }
        return changed;
    }

    @Override
    protected MetadataUpdateEvent getEmptyData() {
        return MetadataUpdateEvent.emptyUpdate();
    }

    @Subscribe
    public void onServiceCreate(ServiceInstalledEvent serviceInstalledEvent) throws OBDPException {
        Cluster cluster = ((Clusters)this.m_clusters.get()).getCluster(serviceInstalledEvent.getClusterId());
        this.updateData(this.ambariManagementController.getClusterMetadataOnServiceInstall(cluster, serviceInstalledEvent.getServiceName()));
    }

    @Subscribe
    public void onClusterComponentsRepoUpdate(ClusterComponentsRepoChangedEvent clusterComponentsRepoChangedEvent) throws OBDPException {
        Cluster cluster = ((Clusters)this.m_clusters.get()).getCluster(clusterComponentsRepoChangedEvent.getClusterId());
        this.updateData(this.ambariManagementController.getClusterMetadataOnRepoUpdate(cluster));
    }

    @Subscribe
    public void onServiceCredentialStoreUpdate(ServiceCredentialStoreUpdateEvent serviceCredentialStoreUpdateEvent) throws OBDPException {
        Cluster cluster = ((Clusters)this.m_clusters.get()).getCluster(serviceCredentialStoreUpdateEvent.getClusterId());
        this.updateData(this.ambariManagementController.getClusterMetadataOnServiceCredentialStoreUpdate(cluster, serviceCredentialStoreUpdateEvent.getServiceName()));
    }

    @Subscribe
    public void onAmbariPropertiesChange(AmbariPropertiesChangedEvent event) throws OBDPException {
        this.updateData(this.ambariManagementController.getClustersMetadata());
    }
}

