/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.RecoveryConfig;
import id.onyx.obdp.server.agent.RecoveryConfigHelper;
import id.onyx.obdp.server.agent.stomp.AgentHostDataHolder;
import id.onyx.obdp.server.agent.stomp.dto.HostLevelParamsCluster;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.events.ClusterComponentsRepoChangedEvent;
import id.onyx.obdp.server.events.HostLevelParamsUpdateEvent;
import id.onyx.obdp.server.events.MaintenanceModeEvent;
import id.onyx.obdp.server.events.ServiceComponentRecoveryChangedEvent;
import id.onyx.obdp.server.events.publishers.OBDPEventPublisher;
import id.onyx.obdp.server.state.BlueprintProvisioningState;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.ServiceComponentHost;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;

@Singleton
public class HostLevelParamsHolder
extends AgentHostDataHolder<HostLevelParamsUpdateEvent> {
    @Inject
    private RecoveryConfigHelper recoveryConfigHelper;
    @Inject
    private Provider<OBDPManagementController> m_ambariManagementController;
    @Inject
    private Clusters clusters;

    @Inject
    public HostLevelParamsHolder(OBDPEventPublisher ambariEventPublisher) {
        ambariEventPublisher.register(this);
    }

    @Override
    public HostLevelParamsUpdateEvent getCurrentData(Long hostId) throws OBDPException {
        return this.getCurrentDataExcludeCluster(hostId, null);
    }

    public HostLevelParamsUpdateEvent getCurrentDataExcludeCluster(Long hostId, Long clusterId) throws OBDPException {
        TreeMap<String, HostLevelParamsCluster> hostLevelParamsClusters = new TreeMap<String, HostLevelParamsCluster>();
        Host host = this.clusters.getHostById(hostId);
        for (Cluster cl : this.clusters.getClustersForHost(host.getHostName())) {
            if (clusterId != null && cl.getClusterId() == clusterId.longValue()) continue;
            HostLevelParamsCluster hostLevelParamsCluster = new HostLevelParamsCluster(this.recoveryConfigHelper.getRecoveryConfig(cl.getClusterName(), host.getHostName()), ((OBDPManagementController)this.m_ambariManagementController.get()).getBlueprintProvisioningStates(cl.getClusterId(), host.getHostId()));
            hostLevelParamsClusters.put(Long.toString(cl.getClusterId()), hostLevelParamsCluster);
        }
        return new HostLevelParamsUpdateEvent(hostId, hostLevelParamsClusters);
    }

    public void updateAllHosts() throws OBDPException {
        for (Host host : this.clusters.getHosts()) {
            this.updateData(this.getCurrentData(host.getHostId()));
        }
    }

    @Override
    protected HostLevelParamsUpdateEvent handleUpdate(HostLevelParamsUpdateEvent current, HostLevelParamsUpdateEvent update) {
        HostLevelParamsUpdateEvent result = null;
        boolean changed = false;
        HashMap<String, HostLevelParamsCluster> mergedClusters = new HashMap<String, HostLevelParamsCluster>();
        if (MapUtils.isNotEmpty(update.getHostLevelParamsClusters())) {
            String clusterId;
            for (Map.Entry<String, HostLevelParamsCluster> hostLevelParamsClusterEntry : current.getHostLevelParamsClusters().entrySet()) {
                clusterId = hostLevelParamsClusterEntry.getKey();
                if (update.getHostLevelParamsClusters().containsKey(clusterId)) continue;
                mergedClusters.put(clusterId, hostLevelParamsClusterEntry.getValue());
            }
            for (Map.Entry<String, HostLevelParamsCluster> hostLevelParamsClusterEntry : update.getHostLevelParamsClusters().entrySet()) {
                clusterId = hostLevelParamsClusterEntry.getKey();
                if (current.getHostLevelParamsClusters().containsKey(clusterId)) {
                    Map<String, BlueprintProvisioningState> mergedBlueprintProvisioningStates;
                    RecoveryConfig mergedRecoveryConfig;
                    boolean clusterChanged = false;
                    HostLevelParamsCluster updatedCluster = hostLevelParamsClusterEntry.getValue();
                    HostLevelParamsCluster currentCluster = current.getHostLevelParamsClusters().get(clusterId);
                    if (!currentCluster.getRecoveryConfig().equals(updatedCluster.getRecoveryConfig())) {
                        mergedRecoveryConfig = updatedCluster.getRecoveryConfig();
                        clusterChanged = true;
                    } else {
                        mergedRecoveryConfig = currentCluster.getRecoveryConfig();
                    }
                    if (!currentCluster.getBlueprintProvisioningState().equals(updatedCluster.getBlueprintProvisioningState())) {
                        mergedBlueprintProvisioningStates = updatedCluster.getBlueprintProvisioningState();
                        clusterChanged = true;
                    } else {
                        mergedBlueprintProvisioningStates = currentCluster.getBlueprintProvisioningState();
                    }
                    if (clusterChanged) {
                        HostLevelParamsCluster mergedCluster = new HostLevelParamsCluster(mergedRecoveryConfig, mergedBlueprintProvisioningStates);
                        mergedClusters.put(clusterId, mergedCluster);
                        changed = true;
                        continue;
                    }
                    mergedClusters.put(clusterId, hostLevelParamsClusterEntry.getValue());
                    continue;
                }
                mergedClusters.put(clusterId, hostLevelParamsClusterEntry.getValue());
                changed = true;
            }
        }
        if (changed) {
            result = new HostLevelParamsUpdateEvent(current.getHostId(), mergedClusters);
        }
        return result;
    }

    @Override
    protected HostLevelParamsUpdateEvent getEmptyData() {
        return HostLevelParamsUpdateEvent.emptyUpdate();
    }

    @Subscribe
    public void onClusterComponentsRepoUpdate(ClusterComponentsRepoChangedEvent clusterComponentsRepoChangedEvent) throws OBDPException {
        Cluster cluster = this.clusters.getCluster(clusterComponentsRepoChangedEvent.getClusterId());
        for (Host host : cluster.getHosts()) {
            this.updateDataOfHost(clusterComponentsRepoChangedEvent.getClusterId(), cluster, host);
        }
    }

    @Subscribe
    public void onServiceComponentRecoveryChanged(ServiceComponentRecoveryChangedEvent event) throws OBDPException {
        long clusterId = event.getClusterId();
        Cluster cluster = this.clusters.getCluster(clusterId);
        for (ServiceComponentHost host : cluster.getServiceComponentHosts(event.getServiceName(), event.getComponentName())) {
            this.updateDataOfHost(clusterId, cluster, host.getHost());
        }
    }

    private void updateDataOfHost(long clusterId, Cluster cluster, Host host) throws OBDPException {
        HostLevelParamsUpdateEvent hostLevelParamsUpdateEvent = new HostLevelParamsUpdateEvent(host.getHostId(), Long.toString(clusterId), new HostLevelParamsCluster(this.recoveryConfigHelper.getRecoveryConfig(cluster.getClusterName(), host.getHostName()), ((OBDPManagementController)this.m_ambariManagementController.get()).getBlueprintProvisioningStates(clusterId, host.getHostId())));
        this.updateData(hostLevelParamsUpdateEvent);
    }

    @Subscribe
    public void onMaintenanceModeChanged(MaintenanceModeEvent event) throws OBDPException {
        long clusterId = event.getClusterId();
        Cluster cluster = this.clusters.getCluster(clusterId);
        if (event.getHost() != null || event.getServiceComponentHost() != null) {
            Host host = event.getHost() != null ? event.getHost() : event.getServiceComponentHost().getHost();
            this.updateDataOfHost(clusterId, cluster, host);
        } else if (event.getService() != null) {
            for (String hostName : event.getService().getServiceHosts()) {
                this.updateDataOfHost(clusterId, cluster, cluster.getHost(hostName));
            }
        }
    }
}

