/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Injector;
import com.google.inject.persist.UnitOfWork;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.AgentSessionManager;
import id.onyx.obdp.server.agent.HeartBeat;
import id.onyx.obdp.server.agent.HeartBeatHandler;
import id.onyx.obdp.server.agent.HeartBeatResponse;
import id.onyx.obdp.server.agent.Register;
import id.onyx.obdp.server.agent.RegistrationResponse;
import id.onyx.obdp.server.agent.RegistrationStatus;
import id.onyx.obdp.server.agent.stomp.AgentsRegistrationQueue;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.configuration.spring.GuiceBeansConfig;
import id.onyx.obdp.server.state.cluster.ClustersImpl;
import id.onyx.obdp.server.state.fsm.InvalidStateTransitionException;
import jakarta.ws.rs.WebApplicationException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.stereotype.Controller;

@Controller
@SendToUser(value={"/"})
@MessageMapping(value={"/"})
@Import(value={GuiceBeansConfig.class})
public class HeartbeatController {
    private static Logger LOG = LoggerFactory.getLogger(HeartbeatController.class);
    private final HeartBeatHandler hh;
    private final ClustersImpl clusters;
    private final AgentSessionManager agentSessionManager;
    private final LinkedBlockingQueue queue;
    private final ThreadFactory threadFactoryExecutor = new ThreadFactoryBuilder().setNameFormat("agent-register-processor-%d").build();
    private final ThreadFactory threadFactoryTimeout = new ThreadFactoryBuilder().setNameFormat("agent-register-timeout-%d").build();
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final UnitOfWork unitOfWork;
    @Autowired
    private AgentsRegistrationQueue agentsRegistrationQueue;

    public HeartbeatController(Injector injector) {
        this.hh = (HeartBeatHandler)injector.getInstance(HeartBeatHandler.class);
        this.clusters = (ClustersImpl)injector.getInstance(ClustersImpl.class);
        this.unitOfWork = (UnitOfWork)injector.getInstance(UnitOfWork.class);
        this.agentSessionManager = (AgentSessionManager)injector.getInstance(AgentSessionManager.class);
        Configuration configuration = (Configuration)injector.getInstance(Configuration.class);
        this.queue = new LinkedBlockingQueue(configuration.getAgentsRegistrationQueueSize());
        this.executor = new ThreadPoolExecutor(configuration.getRegistrationThreadPoolSize(), configuration.getRegistrationThreadPoolSize(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.queue, this.threadFactoryExecutor);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, this.threadFactoryTimeout);
    }

    @MessageMapping(value={"/register"})
    public CompletableFuture<RegistrationResponse> register(@Header String simpSessionId, Register message) throws WebApplicationException, InvalidStateTransitionException, OBDPException {
        CompletableFuture<RegistrationResponse> completableFuture = new CompletableFuture<RegistrationResponse>();
        Future<RegistrationResponse> future = this.executor.submit(() -> {
            try {
                this.unitOfWork.begin();
                RegistrationResponse response = null;
                try {
                    response = this.hh.handleRegistration(message);
                    this.agentSessionManager.register(simpSessionId, this.clusters.getHost(message.getHostname()));
                    LOG.debug("Sending registration response " + response);
                }
                catch (Exception ex) {
                    LOG.info(ex.getMessage(), (Throwable)ex);
                    response = new RegistrationResponse();
                    response.setResponseId(-1L);
                    response.setResponseStatus(RegistrationStatus.FAILED);
                    response.setExitstatus(1);
                    response.setLog(ex.getMessage());
                    completableFuture.complete(response);
                    RegistrationResponse registrationResponse = response;
                    this.unitOfWork.end();
                    return registrationResponse;
                }
                completableFuture.complete(response);
                RegistrationResponse registrationResponse = response;
                return registrationResponse;
            }
            finally {
                this.unitOfWork.end();
            }
        });
        this.scheduledExecutorService.schedule(new RegistrationTimeoutTask(future, completableFuture), 8L, TimeUnit.SECONDS);
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MessageMapping(value={"/heartbeat"})
    public HeartBeatResponse heartbeat(@Header String simpSessionId, HeartBeat message) {
        try {
            block9: {
                this.unitOfWork.begin();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received Heartbeat message " + message);
                }
                try {
                    if (this.agentSessionManager.isRegistered(simpSessionId)) break block9;
                    LOG.error(String.format("Host with [%s] sessionId not registered", simpSessionId));
                    HeartBeatResponse heartBeatResponse = this.hh.createRegisterCommand();
                    return heartBeatResponse;
                }
                catch (Exception e) {
                    LOG.warn("Error in HeartBeat", (Throwable)e);
                    throw new WebApplicationException(500);
                }
            }
            message.setHostname(this.agentSessionManager.getHost(simpSessionId).getHostName());
            HeartBeatResponse heartBeatResponse = this.hh.handleHeartBeat(message);
            this.agentsRegistrationQueue.complete(simpSessionId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending heartbeat response with response id " + heartBeatResponse.getResponseId());
                LOG.debug("Response details " + heartBeatResponse);
            }
            HeartBeatResponse heartBeatResponse2 = heartBeatResponse;
            return heartBeatResponse2;
        }
        finally {
            this.unitOfWork.end();
        }
    }

    private class RegistrationTimeoutTask
    implements Runnable {
        private Future<RegistrationResponse> task;
        private CompletableFuture<RegistrationResponse> completableFuture;

        public RegistrationTimeoutTask(Future<RegistrationResponse> task, CompletableFuture<RegistrationResponse> completableFuture) {
            this.task = task;
            this.completableFuture = completableFuture;
        }

        @Override
        public void run() {
            boolean cancelled = this.task.cancel(false);
            if (cancelled) {
                this.completableFuture.cancel(false);
            }
        }
    }
}

