/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.agent.stomp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.broker.AbstractSubscriptionRegistry;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;

public class AmbariSubscriptionRegistry
extends AbstractSubscriptionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariSubscriptionRegistry.class);
    private static final EvaluationContext messageEvalContext = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{new SimpMessageHeaderPropertyAccessor()}).build();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private volatile int cacheLimit;
    private String selectorHeaderName = "selector";
    private volatile boolean selectorHeaderInUse = false;
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private final DestinationCache destinationCache;
    private final SessionSubscriptionRegistry subscriptionRegistry = new SessionSubscriptionRegistry();

    public AmbariSubscriptionRegistry(int cacheLimit) {
        this.cacheLimit = cacheLimit;
        this.destinationCache = new DestinationCache();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setSelectorHeaderName(String selectorHeaderName) {
        Assert.notNull((Object)selectorHeaderName, (String)"'selectorHeaderName' must not be null");
        this.selectorHeaderName = selectorHeaderName;
    }

    public String getSelectorHeaderName() {
        return this.selectorHeaderName;
    }

    protected void addSubscriptionInternal(String sessionId, String subsId, String destination, Message<?> message) {
        Expression expression = this.getSelectorExpression(message.getHeaders());
        this.subscriptionRegistry.addSubscription(sessionId, subsId, destination, expression);
        this.destinationCache.updateAfterNewSubscription(destination, sessionId, subsId);
    }

    @Nullable
    private Expression getSelectorExpression(MessageHeaders headers) {
        Expression expression;
        block4: {
            String selector;
            expression = null;
            if (this.getSelectorHeaderName() != null && (selector = SimpMessageHeaderAccessor.getFirstNativeHeader((String)this.getSelectorHeaderName(), (Map)headers)) != null) {
                try {
                    expression = this.expressionParser.parseExpression(selector);
                    this.selectorHeaderInUse = true;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Subscription selector: [" + selector + "]"));
                    }
                }
                catch (Throwable ex) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)("Failed to parse selector: " + selector), ex);
                }
            }
        }
        return expression;
    }

    protected void removeSubscriptionInternal(String sessionId, String subsId, Message<?> message) {
        String destination;
        SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions(sessionId);
        if (info != null && (destination = info.removeSubscription(subsId)) != null) {
            this.destinationCache.updateAfterRemovedSubscription(sessionId, subsId);
        }
    }

    public void unregisterAllSubscriptions(String sessionId) {
        SessionSubscriptionInfo info = this.subscriptionRegistry.removeSubscriptions(sessionId);
        if (info != null) {
            this.destinationCache.updateAfterRemovedSession(info);
        }
    }

    protected MultiValueMap<String, String> findSubscriptionsInternal(String destination, Message<?> message) {
        LinkedMultiValueMap<String, String> result = this.destinationCache.getSubscriptions(destination, message);
        return this.filterSubscriptions((MultiValueMap<String, String>)result, message);
    }

    private MultiValueMap<String, String> filterSubscriptions(MultiValueMap<String, String> allMatches, Message<?> message) {
        if (!this.selectorHeaderInUse) {
            return allMatches;
        }
        LinkedMultiValueMap result = new LinkedMultiValueMap(allMatches.size());
        allMatches.forEach((arg_0, arg_1) -> this.lambda$filterSubscriptions$1((MultiValueMap)result, message, arg_0, arg_1));
        return result;
    }

    public String toString() {
        return "DefaultSubscriptionRegistry[" + this.destinationCache + ", " + this.subscriptionRegistry + "]";
    }

    private /* synthetic */ void lambda$filterSubscriptions$1(MultiValueMap result, Message message, String sessionId, List subIds) {
        subIds.forEach(subId -> {
            SessionSubscriptionInfo info = this.subscriptionRegistry.getSubscriptions(sessionId);
            if (info == null) {
                return;
            }
            Subscription sub = info.getSubscription((String)subId);
            if (sub == null) {
                return;
            }
            Expression expression = sub.getSelectorExpression();
            if (expression == null) {
                result.add((Object)sessionId, subId);
                return;
            }
            try {
                if (Boolean.TRUE.equals(expression.getValue(messageEvalContext, (Object)message, Boolean.class))) {
                    result.add((Object)sessionId, subId);
                }
            }
            catch (SpelEvaluationException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to evaluate selector: " + ex.getMessage()));
                }
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Failed to evaluate selector", ex);
            }
        });
    }

    private static class SessionSubscriptionRegistry {
        private final ConcurrentMap<String, SessionSubscriptionInfo> sessions = new ConcurrentHashMap<String, SessionSubscriptionInfo>();

        private SessionSubscriptionRegistry() {
        }

        @Nullable
        public SessionSubscriptionInfo getSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.get(sessionId);
        }

        public Collection<SessionSubscriptionInfo> getAllSubscriptions() {
            return this.sessions.values();
        }

        public SessionSubscriptionInfo addSubscription(String sessionId, String subscriptionId, String destination, @Nullable Expression selectorExpression) {
            SessionSubscriptionInfo value;
            SessionSubscriptionInfo info = (SessionSubscriptionInfo)this.sessions.get(sessionId);
            if (info == null && (value = this.sessions.putIfAbsent(sessionId, info = new SessionSubscriptionInfo(sessionId))) != null) {
                info = value;
            }
            info.addSubscription(destination, subscriptionId, selectorExpression);
            return info;
        }

        @Nullable
        public SessionSubscriptionInfo removeSubscriptions(String sessionId) {
            return (SessionSubscriptionInfo)this.sessions.remove(sessionId);
        }

        public String toString() {
            return "registry[" + this.sessions.size() + " sessions]";
        }
    }

    private class DestinationCache {
        private final Map<String, LinkedMultiValueMap<String, String>> accessCache;
        private final Cache<String, String> notSubscriptionCache;

        private DestinationCache() {
            this.accessCache = new ConcurrentHashMap<String, LinkedMultiValueMap<String, String>>(AmbariSubscriptionRegistry.this.cacheLimit);
            this.notSubscriptionCache = CacheBuilder.newBuilder().maximumSize((long)AmbariSubscriptionRegistry.this.cacheLimit).build();
        }

        public LinkedMultiValueMap<String, String> getSubscriptions(String destination, Message<?> message) {
            LinkedMultiValueMap copiedSubscriptions = new LinkedMultiValueMap();
            if (this.notSubscriptionCache.asMap().keySet().contains(destination)) {
                return copiedSubscriptions;
            }
            this.accessCache.compute(destination, (key, value) -> {
                if (value == null) {
                    LinkedMultiValueMap result = new LinkedMultiValueMap();
                    AmbariSubscriptionRegistry.this.subscriptionRegistry.getAllSubscriptions().forEach(info -> info.getDestinations().forEach(destinationPattern -> {
                        if (destinationPattern.equals(destination)) {
                            info.getSubscriptions((String)destinationPattern).forEach(subscription -> result.add((Object)info.sessionId, (Object)subscription.getId()));
                        }
                    }));
                    if (!result.isEmpty()) {
                        copiedSubscriptions.addAll((MultiValueMap)result.deepCopy());
                        return result;
                    }
                    this.notSubscriptionCache.put((Object)destination, (Object)"");
                    return null;
                }
                copiedSubscriptions.addAll((MultiValueMap)value.deepCopy());
                return value;
            });
            return copiedSubscriptions;
        }

        public void updateAfterNewSubscription(String destination, String sessionId, String subsId) {
            LinkedMultiValueMap updatedMap = this.accessCache.computeIfPresent(destination, (key, value) -> {
                if (AmbariSubscriptionRegistry.this.getPathMatcher().match(destination, key)) {
                    LinkedMultiValueMap subs = value;
                    subs.add((Object)sessionId, (Object)subsId);
                    return subs;
                }
                return value;
            });
            if (updatedMap == null) {
                this.notSubscriptionCache.invalidate((Object)destination);
            }
        }

        public void updateAfterRemovedSubscription(String sessionId, String subsId) {
            for (Map.Entry<String, LinkedMultiValueMap<String, String>> entry : this.accessCache.entrySet()) {
                String destination = entry.getKey();
                this.accessCache.compute(destination, (key, value) -> {
                    List subscriptions;
                    if (value != null && (subscriptions = value.get((Object)sessionId)) != null) {
                        subscriptions.remove(subsId);
                        if (subscriptions.isEmpty()) {
                            value.remove((Object)sessionId);
                        }
                        if (value.isEmpty()) {
                            return null;
                        }
                        this.notSubscriptionCache.invalidate((Object)destination);
                    }
                    return value;
                });
            }
        }

        public void updateAfterRemovedSession(SessionSubscriptionInfo info) {
            for (Map.Entry<String, LinkedMultiValueMap<String, String>> entry : this.accessCache.entrySet()) {
                String destination = entry.getKey();
                this.accessCache.compute(destination, (key, value) -> {
                    if (value != null && value.remove((Object)info.getSessionId()) != null) {
                        if (value.isEmpty()) {
                            return null;
                        }
                        this.notSubscriptionCache.invalidate((Object)destination);
                    }
                    return value;
                });
            }
        }

        public String toString() {
            return "cache[" + this.accessCache.size() + " destination(s)]";
        }
    }

    private static class SessionSubscriptionInfo {
        private final String sessionId;
        private final Map<String, Set<Subscription>> destinationLookup = new ConcurrentHashMap<String, Set<Subscription>>(4);

        public SessionSubscriptionInfo(String sessionId) {
            Assert.notNull((Object)sessionId, (String)"'sessionId' must not be null");
            this.sessionId = sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Set<String> getDestinations() {
            return this.destinationLookup.keySet();
        }

        public Set<Subscription> getSubscriptions(String destination) {
            return this.destinationLookup.get(destination);
        }

        @Nullable
        public Subscription getSubscription(String subscriptionId) {
            for (Map.Entry<String, Set<Subscription>> destinationEntry : this.destinationLookup.entrySet()) {
                for (Subscription sub : destinationEntry.getValue()) {
                    if (!sub.getId().equalsIgnoreCase(subscriptionId)) continue;
                    return sub;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubscription(String destination, String subscriptionId, @Nullable Expression selectorExpression) {
            Set<Subscription> subs = this.destinationLookup.get(destination);
            if (subs == null) {
                Map<String, Set<Subscription>> map = this.destinationLookup;
                synchronized (map) {
                    subs = this.destinationLookup.get(destination);
                    if (subs == null) {
                        subs = new CopyOnWriteArraySet<Subscription>();
                        this.destinationLookup.put(destination, subs);
                    }
                }
            }
            subs.add(new Subscription(subscriptionId, selectorExpression));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public String removeSubscription(String subscriptionId) {
            for (Map.Entry<String, Set<Subscription>> destinationEntry : this.destinationLookup.entrySet()) {
                Set<Subscription> subs = destinationEntry.getValue();
                if (subs == null) continue;
                for (Subscription sub : subs) {
                    if (!sub.getId().equals(subscriptionId) || !subs.remove(sub)) continue;
                    Map<String, Set<Subscription>> map = this.destinationLookup;
                    synchronized (map) {
                        if (subs.isEmpty()) {
                            this.destinationLookup.remove(destinationEntry.getKey());
                        }
                    }
                    return destinationEntry.getKey();
                }
            }
            return null;
        }

        public String toString() {
            return "[sessionId=" + this.sessionId + ", subscriptions=" + this.destinationLookup + "]";
        }
    }

    private static final class Subscription {
        private final String id;
        @Nullable
        private final Expression selectorExpression;

        public Subscription(String id, @Nullable Expression selector) {
            Assert.notNull((Object)id, (String)"Subscription id must not be null");
            this.id = id;
            this.selectorExpression = selector;
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public Expression getSelectorExpression() {
            return this.selectorExpression;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Subscription && this.id.equals(((Subscription)other).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "subscription(id=" + this.id + ")";
        }
    }

    private static class SimpMessageHeaderPropertyAccessor
    implements PropertyAccessor {
        private SimpMessageHeaderPropertyAccessor() {
        }

        public Class<?>[] getSpecificTargetClasses() {
            return new Class[]{Message.class, MessageHeaders.class};
        }

        public boolean canRead(EvaluationContext context, @Nullable Object target, String name) {
            return true;
        }

        public TypedValue read(EvaluationContext context, @Nullable Object target, String name) {
            Object value;
            if (target instanceof Message) {
                value = name.equals("headers") ? ((Message)target).getHeaders() : null;
            } else if (target instanceof MessageHeaders) {
                MessageHeaders headers = (MessageHeaders)target;
                SimpMessageHeaderAccessor accessor = (SimpMessageHeaderAccessor)MessageHeaderAccessor.getAccessor((MessageHeaders)headers, SimpMessageHeaderAccessor.class);
                Assert.state((accessor != null ? 1 : 0) != 0, (String)"No SimpMessageHeaderAccessor");
                if ("destination".equalsIgnoreCase(name)) {
                    value = accessor.getDestination();
                } else {
                    value = accessor.getFirstNativeHeader(name);
                    if (value == null) {
                        value = headers.get((Object)name);
                    }
                }
            } else {
                throw new IllegalStateException("Expected Message or MessageHeaders.");
            }
            return new TypedValue(value);
        }

        public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) {
            return false;
        }

        public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object value) {
        }
    }
}

